/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.catalog;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.catalog.CreateDatabaseCatalogRequest;
import com.databricks.sdk.service.catalog.CreateDatabaseInstanceRequest;
import com.databricks.sdk.service.catalog.CreateSyncedDatabaseTableRequest;
import com.databricks.sdk.service.catalog.DatabaseCatalog;
import com.databricks.sdk.service.catalog.DatabaseInstance;
import com.databricks.sdk.service.catalog.DatabaseInstancesImpl;
import com.databricks.sdk.service.catalog.DatabaseInstancesService;
import com.databricks.sdk.service.catalog.DeleteDatabaseCatalogRequest;
import com.databricks.sdk.service.catalog.DeleteDatabaseInstanceRequest;
import com.databricks.sdk.service.catalog.DeleteSyncedDatabaseTableRequest;
import com.databricks.sdk.service.catalog.FindDatabaseInstanceByUidRequest;
import com.databricks.sdk.service.catalog.GetDatabaseCatalogRequest;
import com.databricks.sdk.service.catalog.GetDatabaseInstanceRequest;
import com.databricks.sdk.service.catalog.GetSyncedDatabaseTableRequest;
import com.databricks.sdk.service.catalog.ListDatabaseInstancesRequest;
import com.databricks.sdk.service.catalog.ListDatabaseInstancesResponse;
import com.databricks.sdk.service.catalog.SyncedDatabaseTable;
import com.databricks.sdk.service.catalog.UpdateDatabaseInstanceRequest;
import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class DatabaseInstancesAPI {
    private static final Logger LOG = LoggerFactory.getLogger(DatabaseInstancesAPI.class);
    private final DatabaseInstancesService impl;

    public DatabaseInstancesAPI(ApiClient apiClient) {
        this.impl = new DatabaseInstancesImpl(apiClient);
    }

    public DatabaseInstancesAPI(DatabaseInstancesService mock) {
        this.impl = mock;
    }

    public DatabaseCatalog createDatabaseCatalog(DatabaseCatalog catalog) {
        return this.createDatabaseCatalog(new CreateDatabaseCatalogRequest().setCatalog(catalog));
    }

    public DatabaseCatalog createDatabaseCatalog(CreateDatabaseCatalogRequest request) {
        return this.impl.createDatabaseCatalog(request);
    }

    public DatabaseInstance createDatabaseInstance(DatabaseInstance databaseInstance) {
        return this.createDatabaseInstance(new CreateDatabaseInstanceRequest().setDatabaseInstance(databaseInstance));
    }

    public DatabaseInstance createDatabaseInstance(CreateDatabaseInstanceRequest request) {
        return this.impl.createDatabaseInstance(request);
    }

    public SyncedDatabaseTable createSyncedDatabaseTable(SyncedDatabaseTable syncedTable) {
        return this.createSyncedDatabaseTable(new CreateSyncedDatabaseTableRequest().setSyncedTable(syncedTable));
    }

    public SyncedDatabaseTable createSyncedDatabaseTable(CreateSyncedDatabaseTableRequest request) {
        return this.impl.createSyncedDatabaseTable(request);
    }

    public void deleteDatabaseCatalog(String name) {
        this.deleteDatabaseCatalog(new DeleteDatabaseCatalogRequest().setName(name));
    }

    public void deleteDatabaseCatalog(DeleteDatabaseCatalogRequest request) {
        this.impl.deleteDatabaseCatalog(request);
    }

    public void deleteDatabaseInstance(String name) {
        this.deleteDatabaseInstance(new DeleteDatabaseInstanceRequest().setName(name));
    }

    public void deleteDatabaseInstance(DeleteDatabaseInstanceRequest request) {
        this.impl.deleteDatabaseInstance(request);
    }

    public void deleteSyncedDatabaseTable(String name) {
        this.deleteSyncedDatabaseTable(new DeleteSyncedDatabaseTableRequest().setName(name));
    }

    public void deleteSyncedDatabaseTable(DeleteSyncedDatabaseTableRequest request) {
        this.impl.deleteSyncedDatabaseTable(request);
    }

    public DatabaseInstance findDatabaseInstanceByUid(FindDatabaseInstanceByUidRequest request) {
        return this.impl.findDatabaseInstanceByUid(request);
    }

    public DatabaseCatalog getDatabaseCatalog(String name) {
        return this.getDatabaseCatalog(new GetDatabaseCatalogRequest().setName(name));
    }

    public DatabaseCatalog getDatabaseCatalog(GetDatabaseCatalogRequest request) {
        return this.impl.getDatabaseCatalog(request);
    }

    public DatabaseInstance getDatabaseInstance(String name) {
        return this.getDatabaseInstance(new GetDatabaseInstanceRequest().setName(name));
    }

    public DatabaseInstance getDatabaseInstance(GetDatabaseInstanceRequest request) {
        return this.impl.getDatabaseInstance(request);
    }

    public SyncedDatabaseTable getSyncedDatabaseTable(String name) {
        return this.getSyncedDatabaseTable(new GetSyncedDatabaseTableRequest().setName(name));
    }

    public SyncedDatabaseTable getSyncedDatabaseTable(GetSyncedDatabaseTableRequest request) {
        return this.impl.getSyncedDatabaseTable(request);
    }

    public Iterable<DatabaseInstance> listDatabaseInstances(ListDatabaseInstancesRequest request) {
        return new Paginator(request, this.impl::listDatabaseInstances, ListDatabaseInstancesResponse::getDatabaseInstances, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public DatabaseInstance updateDatabaseInstance(String name, DatabaseInstance databaseInstance, String updateMask) {
        return this.updateDatabaseInstance(new UpdateDatabaseInstanceRequest().setName(name).setDatabaseInstance(databaseInstance).setUpdateMask(updateMask));
    }

    public DatabaseInstance updateDatabaseInstance(UpdateDatabaseInstanceRequest request) {
        return this.impl.updateDatabaseInstance(request);
    }

    public DatabaseInstancesService impl() {
        return this.impl;
    }
}

