/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.catalog;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.service.catalog.CreateDatabaseCatalogRequest;
import com.databricks.sdk.service.catalog.CreateDatabaseInstanceRequest;
import com.databricks.sdk.service.catalog.CreateSyncedDatabaseTableRequest;
import com.databricks.sdk.service.catalog.DatabaseCatalog;
import com.databricks.sdk.service.catalog.DatabaseInstance;
import com.databricks.sdk.service.catalog.DatabaseInstancesService;
import com.databricks.sdk.service.catalog.DeleteDatabaseCatalogRequest;
import com.databricks.sdk.service.catalog.DeleteDatabaseCatalogResponse;
import com.databricks.sdk.service.catalog.DeleteDatabaseInstanceRequest;
import com.databricks.sdk.service.catalog.DeleteDatabaseInstanceResponse;
import com.databricks.sdk.service.catalog.DeleteSyncedDatabaseTableRequest;
import com.databricks.sdk.service.catalog.DeleteSyncedDatabaseTableResponse;
import com.databricks.sdk.service.catalog.FindDatabaseInstanceByUidRequest;
import com.databricks.sdk.service.catalog.GetDatabaseCatalogRequest;
import com.databricks.sdk.service.catalog.GetDatabaseInstanceRequest;
import com.databricks.sdk.service.catalog.GetSyncedDatabaseTableRequest;
import com.databricks.sdk.service.catalog.ListDatabaseInstancesRequest;
import com.databricks.sdk.service.catalog.ListDatabaseInstancesResponse;
import com.databricks.sdk.service.catalog.SyncedDatabaseTable;
import com.databricks.sdk.service.catalog.UpdateDatabaseInstanceRequest;
import com.databricks.sdk.support.Generated;
import java.io.IOException;

@Generated
class DatabaseInstancesImpl
implements DatabaseInstancesService {
    private final ApiClient apiClient;

    public DatabaseInstancesImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public DatabaseCatalog createDatabaseCatalog(CreateDatabaseCatalogRequest request) {
        String path = "/api/2.0/database/catalogs";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request.getCatalog()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, DatabaseCatalog.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public DatabaseInstance createDatabaseInstance(CreateDatabaseInstanceRequest request) {
        String path = "/api/2.0/database/instances";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request.getDatabaseInstance()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, DatabaseInstance.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public SyncedDatabaseTable createSyncedDatabaseTable(CreateSyncedDatabaseTableRequest request) {
        String path = "/api/2.0/database/synced_tables";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request.getSyncedTable()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, SyncedDatabaseTable.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteDatabaseCatalog(DeleteDatabaseCatalogRequest request) {
        String path = String.format("/api/2.0/database/catalogs/%s", request.getName());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, DeleteDatabaseCatalogResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteDatabaseInstance(DeleteDatabaseInstanceRequest request) {
        String path = String.format("/api/2.0/database/instances/%s", request.getName());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, DeleteDatabaseInstanceResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteSyncedDatabaseTable(DeleteSyncedDatabaseTableRequest request) {
        String path = String.format("/api/2.0/database/synced_tables/%s", request.getName());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, DeleteSyncedDatabaseTableResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public DatabaseInstance findDatabaseInstanceByUid(FindDatabaseInstanceByUidRequest request) {
        String path = "/api/2.0/database/instances:findByUid";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, DatabaseInstance.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public DatabaseCatalog getDatabaseCatalog(GetDatabaseCatalogRequest request) {
        String path = String.format("/api/2.0/database/catalogs/%s", request.getName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, DatabaseCatalog.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public DatabaseInstance getDatabaseInstance(GetDatabaseInstanceRequest request) {
        String path = String.format("/api/2.0/database/instances/%s", request.getName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, DatabaseInstance.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public SyncedDatabaseTable getSyncedDatabaseTable(GetSyncedDatabaseTableRequest request) {
        String path = String.format("/api/2.0/database/synced_tables/%s", request.getName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, SyncedDatabaseTable.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListDatabaseInstancesResponse listDatabaseInstances(ListDatabaseInstancesRequest request) {
        String path = "/api/2.0/database/instances";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListDatabaseInstancesResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public DatabaseInstance updateDatabaseInstance(UpdateDatabaseInstanceRequest request) {
        String path = String.format("/api/2.0/database/instances/%s", request.getName());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request.getDatabaseInstance()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, DatabaseInstance.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

