/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.provisioning;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.service.provisioning.CreateVpcEndpointRequest;
import com.databricks.sdk.service.provisioning.DeleteVpcEndpointRequest;
import com.databricks.sdk.service.provisioning.GetVpcEndpointRequest;
import com.databricks.sdk.service.provisioning.VpcEndpoint;
import com.databricks.sdk.service.provisioning.VpcEndpointsService;
import com.databricks.sdk.support.Generated;
import java.io.IOException;
import java.util.Collection;

@Generated
class VpcEndpointsImpl
implements VpcEndpointsService {
    private final ApiClient apiClient;

    public VpcEndpointsImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public VpcEndpoint create(CreateVpcEndpointRequest request) {
        String path = String.format("/api/2.0/accounts/%s/vpc-endpoints", this.apiClient.configuredAccountID());
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, VpcEndpoint.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeleteVpcEndpointRequest request) {
        String path = String.format("/api/2.0/accounts/%s/vpc-endpoints/%s", this.apiClient.configuredAccountID(), request.getVpcEndpointId());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public VpcEndpoint get(GetVpcEndpointRequest request) {
        String path = String.format("/api/2.0/accounts/%s/vpc-endpoints/%s", this.apiClient.configuredAccountID(), request.getVpcEndpointId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, VpcEndpoint.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public Collection<VpcEndpoint> list() {
        String path = String.format("/api/2.0/accounts/%s/vpc-endpoints", this.apiClient.configuredAccountID());
        Request req = new Request("GET", path);
        req.withHeader("Accept", "application/json");
        return this.apiClient.getCollection(req, VpcEndpoint.class);
    }
}

