// Code generated from OpenAPI specs by Databricks SDK Generator. DO NOT EDIT.

package com.databricks.sdk.service.database;

import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.ToStringer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

/** Status of a synced table. */
@Generated
public class SyncedTableStatus {
  /** */
  @JsonProperty("continuous_update_status")
  private SyncedTableContinuousUpdateStatus continuousUpdateStatus;

  /** The state of the synced table. */
  @JsonProperty("detailed_state")
  private SyncedTableState detailedState;

  /** */
  @JsonProperty("failed_status")
  private SyncedTableFailedStatus failedStatus;

  /**
   * Summary of the last successful synchronization from source to destination.
   *
   * <p>Will always be present if there has been a successful sync. Even if the most recent syncs
   * have failed.
   *
   * <p>Limitation: The only exception is if the synced table is doing a FULL REFRESH, then the last
   * sync information will not be available until the full refresh is complete. This limitation will
   * be addressed in a future version.
   *
   * <p>This top-level field is a convenience for consumers who want easy access to last sync
   * information without having to traverse detailed_status.
   */
  @JsonProperty("last_sync")
  private SyncedTablePosition lastSync;

  /** A text description of the current state of the synced table. */
  @JsonProperty("message")
  private String message;

  /**
   * ID of the associated pipeline. The pipeline ID may have been provided by the client (in the
   * case of bin packing), or generated by the server (when creating a new pipeline).
   */
  @JsonProperty("pipeline_id")
  private String pipelineId;

  /** */
  @JsonProperty("provisioning_status")
  private SyncedTableProvisioningStatus provisioningStatus;

  /** */
  @JsonProperty("triggered_update_status")
  private SyncedTableTriggeredUpdateStatus triggeredUpdateStatus;

  public SyncedTableStatus setContinuousUpdateStatus(
      SyncedTableContinuousUpdateStatus continuousUpdateStatus) {
    this.continuousUpdateStatus = continuousUpdateStatus;
    return this;
  }

  public SyncedTableContinuousUpdateStatus getContinuousUpdateStatus() {
    return continuousUpdateStatus;
  }

  public SyncedTableStatus setDetailedState(SyncedTableState detailedState) {
    this.detailedState = detailedState;
    return this;
  }

  public SyncedTableState getDetailedState() {
    return detailedState;
  }

  public SyncedTableStatus setFailedStatus(SyncedTableFailedStatus failedStatus) {
    this.failedStatus = failedStatus;
    return this;
  }

  public SyncedTableFailedStatus getFailedStatus() {
    return failedStatus;
  }

  public SyncedTableStatus setLastSync(SyncedTablePosition lastSync) {
    this.lastSync = lastSync;
    return this;
  }

  public SyncedTablePosition getLastSync() {
    return lastSync;
  }

  public SyncedTableStatus setMessage(String message) {
    this.message = message;
    return this;
  }

  public String getMessage() {
    return message;
  }

  public SyncedTableStatus setPipelineId(String pipelineId) {
    this.pipelineId = pipelineId;
    return this;
  }

  public String getPipelineId() {
    return pipelineId;
  }

  public SyncedTableStatus setProvisioningStatus(SyncedTableProvisioningStatus provisioningStatus) {
    this.provisioningStatus = provisioningStatus;
    return this;
  }

  public SyncedTableProvisioningStatus getProvisioningStatus() {
    return provisioningStatus;
  }

  public SyncedTableStatus setTriggeredUpdateStatus(
      SyncedTableTriggeredUpdateStatus triggeredUpdateStatus) {
    this.triggeredUpdateStatus = triggeredUpdateStatus;
    return this;
  }

  public SyncedTableTriggeredUpdateStatus getTriggeredUpdateStatus() {
    return triggeredUpdateStatus;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SyncedTableStatus that = (SyncedTableStatus) o;
    return Objects.equals(continuousUpdateStatus, that.continuousUpdateStatus)
        && Objects.equals(detailedState, that.detailedState)
        && Objects.equals(failedStatus, that.failedStatus)
        && Objects.equals(lastSync, that.lastSync)
        && Objects.equals(message, that.message)
        && Objects.equals(pipelineId, that.pipelineId)
        && Objects.equals(provisioningStatus, that.provisioningStatus)
        && Objects.equals(triggeredUpdateStatus, that.triggeredUpdateStatus);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        continuousUpdateStatus,
        detailedState,
        failedStatus,
        lastSync,
        message,
        pipelineId,
        provisioningStatus,
        triggeredUpdateStatus);
  }

  @Override
  public String toString() {
    return new ToStringer(SyncedTableStatus.class)
        .add("continuousUpdateStatus", continuousUpdateStatus)
        .add("detailedState", detailedState)
        .add("failedStatus", failedStatus)
        .add("lastSync", lastSync)
        .add("message", message)
        .add("pipelineId", pipelineId)
        .add("provisioningStatus", provisioningStatus)
        .add("triggeredUpdateStatus", triggeredUpdateStatus)
        .toString();
  }
}
