// Code generated from OpenAPI specs by Databricks SDK Generator. DO NOT EDIT.

package com.databricks.sdk.service.catalog;

import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.ToStringer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.Objects;

@Generated
public class UpdateModelVersionRequest {
  /** List of aliases associated with the model version */
  @JsonProperty("aliases")
  private Collection<RegisteredModelAlias> aliases;

  /** The name of the catalog containing the model version */
  @JsonProperty("catalog_name")
  private String catalogName;

  /** The comment attached to the model version */
  @JsonProperty("comment")
  private String comment;

  /** */
  @JsonProperty("created_at")
  private Long createdAt;

  /** The identifier of the user who created the model version */
  @JsonProperty("created_by")
  private String createdBy;

  /** The three-level (fully qualified) name of the model version */
  @JsonIgnore private String fullName;

  /** The unique identifier of the model version */
  @JsonProperty("id")
  private String id;

  /** The unique identifier of the metastore containing the model version */
  @JsonProperty("metastore_id")
  private String metastoreId;

  /** The name of the parent registered model of the model version, relative to parent schema */
  @JsonProperty("model_name")
  private String modelName;

  /** Model version dependencies, for feature-store packaged models */
  @JsonProperty("model_version_dependencies")
  private DependencyList modelVersionDependencies;

  /**
   * MLflow run ID used when creating the model version, if ``source`` was generated by an
   * experiment run stored in an MLflow tracking server
   */
  @JsonProperty("run_id")
  private String runId;

  /**
   * ID of the Databricks workspace containing the MLflow run that generated this model version, if
   * applicable
   */
  @JsonProperty("run_workspace_id")
  private Long runWorkspaceId;

  /** The name of the schema containing the model version, relative to parent catalog */
  @JsonProperty("schema_name")
  private String schemaName;

  /** URI indicating the location of the source artifacts (files) for the model version */
  @JsonProperty("source")
  private String source;

  /**
   * Current status of the model version. Newly created model versions start in PENDING_REGISTRATION
   * status, then move to READY status once the model version files are uploaded and the model
   * version is finalized. Only model versions in READY status can be loaded for inference or
   * served.
   */
  @JsonProperty("status")
  private ModelVersionInfoStatus status;

  /** The storage location on the cloud under which model version data files are stored */
  @JsonProperty("storage_location")
  private String storageLocation;

  /** */
  @JsonProperty("updated_at")
  private Long updatedAt;

  /** The identifier of the user who updated the model version last time */
  @JsonProperty("updated_by")
  private String updatedBy;

  /** The integer version number of the model version */
  @JsonIgnore private Long version;

  public UpdateModelVersionRequest setAliases(Collection<RegisteredModelAlias> aliases) {
    this.aliases = aliases;
    return this;
  }

  public Collection<RegisteredModelAlias> getAliases() {
    return aliases;
  }

  public UpdateModelVersionRequest setCatalogName(String catalogName) {
    this.catalogName = catalogName;
    return this;
  }

  public String getCatalogName() {
    return catalogName;
  }

  public UpdateModelVersionRequest setComment(String comment) {
    this.comment = comment;
    return this;
  }

  public String getComment() {
    return comment;
  }

  public UpdateModelVersionRequest setCreatedAt(Long createdAt) {
    this.createdAt = createdAt;
    return this;
  }

  public Long getCreatedAt() {
    return createdAt;
  }

  public UpdateModelVersionRequest setCreatedBy(String createdBy) {
    this.createdBy = createdBy;
    return this;
  }

  public String getCreatedBy() {
    return createdBy;
  }

  public UpdateModelVersionRequest setFullName(String fullName) {
    this.fullName = fullName;
    return this;
  }

  public String getFullName() {
    return fullName;
  }

  public UpdateModelVersionRequest setId(String id) {
    this.id = id;
    return this;
  }

  public String getId() {
    return id;
  }

  public UpdateModelVersionRequest setMetastoreId(String metastoreId) {
    this.metastoreId = metastoreId;
    return this;
  }

  public String getMetastoreId() {
    return metastoreId;
  }

  public UpdateModelVersionRequest setModelName(String modelName) {
    this.modelName = modelName;
    return this;
  }

  public String getModelName() {
    return modelName;
  }

  public UpdateModelVersionRequest setModelVersionDependencies(
      DependencyList modelVersionDependencies) {
    this.modelVersionDependencies = modelVersionDependencies;
    return this;
  }

  public DependencyList getModelVersionDependencies() {
    return modelVersionDependencies;
  }

  public UpdateModelVersionRequest setRunId(String runId) {
    this.runId = runId;
    return this;
  }

  public String getRunId() {
    return runId;
  }

  public UpdateModelVersionRequest setRunWorkspaceId(Long runWorkspaceId) {
    this.runWorkspaceId = runWorkspaceId;
    return this;
  }

  public Long getRunWorkspaceId() {
    return runWorkspaceId;
  }

  public UpdateModelVersionRequest setSchemaName(String schemaName) {
    this.schemaName = schemaName;
    return this;
  }

  public String getSchemaName() {
    return schemaName;
  }

  public UpdateModelVersionRequest setSource(String source) {
    this.source = source;
    return this;
  }

  public String getSource() {
    return source;
  }

  public UpdateModelVersionRequest setStatus(ModelVersionInfoStatus status) {
    this.status = status;
    return this;
  }

  public ModelVersionInfoStatus getStatus() {
    return status;
  }

  public UpdateModelVersionRequest setStorageLocation(String storageLocation) {
    this.storageLocation = storageLocation;
    return this;
  }

  public String getStorageLocation() {
    return storageLocation;
  }

  public UpdateModelVersionRequest setUpdatedAt(Long updatedAt) {
    this.updatedAt = updatedAt;
    return this;
  }

  public Long getUpdatedAt() {
    return updatedAt;
  }

  public UpdateModelVersionRequest setUpdatedBy(String updatedBy) {
    this.updatedBy = updatedBy;
    return this;
  }

  public String getUpdatedBy() {
    return updatedBy;
  }

  public UpdateModelVersionRequest setVersion(Long version) {
    this.version = version;
    return this;
  }

  public Long getVersion() {
    return version;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    UpdateModelVersionRequest that = (UpdateModelVersionRequest) o;
    return Objects.equals(aliases, that.aliases)
        && Objects.equals(catalogName, that.catalogName)
        && Objects.equals(comment, that.comment)
        && Objects.equals(createdAt, that.createdAt)
        && Objects.equals(createdBy, that.createdBy)
        && Objects.equals(fullName, that.fullName)
        && Objects.equals(id, that.id)
        && Objects.equals(metastoreId, that.metastoreId)
        && Objects.equals(modelName, that.modelName)
        && Objects.equals(modelVersionDependencies, that.modelVersionDependencies)
        && Objects.equals(runId, that.runId)
        && Objects.equals(runWorkspaceId, that.runWorkspaceId)
        && Objects.equals(schemaName, that.schemaName)
        && Objects.equals(source, that.source)
        && Objects.equals(status, that.status)
        && Objects.equals(storageLocation, that.storageLocation)
        && Objects.equals(updatedAt, that.updatedAt)
        && Objects.equals(updatedBy, that.updatedBy)
        && Objects.equals(version, that.version);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        aliases,
        catalogName,
        comment,
        createdAt,
        createdBy,
        fullName,
        id,
        metastoreId,
        modelName,
        modelVersionDependencies,
        runId,
        runWorkspaceId,
        schemaName,
        source,
        status,
        storageLocation,
        updatedAt,
        updatedBy,
        version);
  }

  @Override
  public String toString() {
    return new ToStringer(UpdateModelVersionRequest.class)
        .add("aliases", aliases)
        .add("catalogName", catalogName)
        .add("comment", comment)
        .add("createdAt", createdAt)
        .add("createdBy", createdBy)
        .add("fullName", fullName)
        .add("id", id)
        .add("metastoreId", metastoreId)
        .add("modelName", modelName)
        .add("modelVersionDependencies", modelVersionDependencies)
        .add("runId", runId)
        .add("runWorkspaceId", runWorkspaceId)
        .add("schemaName", schemaName)
        .add("source", source)
        .add("status", status)
        .add("storageLocation", storageLocation)
        .add("updatedAt", updatedAt)
        .add("updatedBy", updatedBy)
        .add("version", version)
        .toString();
  }
}
