// Code generated from OpenAPI specs by Databricks SDK Generator. DO NOT EDIT.

package com.databricks.sdk.service.catalog;

import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.ToStringer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.Objects;

@Generated
public class PolicyInfo {
  /**
   * Options for column mask policies. Valid only if `policy_type` is `POLICY_TYPE_COLUMN_MASK`.
   * Required on create and optional on update. When specified on update, the new options will
   * replace the existing options as a whole.
   */
  @JsonProperty("column_mask")
  private ColumnMaskOptions columnMask;

  /** Optional description of the policy. */
  @JsonProperty("comment")
  private String comment;

  /** Time at which the policy was created, in epoch milliseconds. Output only. */
  @JsonProperty("created_at")
  private Long createdAt;

  /** Username of the user who created the policy. Output only. */
  @JsonProperty("created_by")
  private String createdBy;

  /** Optional list of user or group names that should be excluded from the policy. */
  @JsonProperty("except_principals")
  private Collection<String> exceptPrincipals;

  /**
   * Type of securables that the policy should take effect on. Only `TABLE` is supported at this
   * moment. Required on create and optional on update.
   */
  @JsonProperty("for_securable_type")
  private SecurableType forSecurableType;

  /** Unique identifier of the policy. This field is output only and is generated by the system. */
  @JsonProperty("id")
  private String id;

  /**
   * Optional list of condition expressions used to match table columns. Only valid when
   * `for_securable_type` is `TABLE`. When specified, the policy only applies to tables whose
   * columns satisfy all match conditions.
   */
  @JsonProperty("match_columns")
  private Collection<MatchColumn> matchColumns;

  /**
   * Name of the policy. Required on create and optional on update. To rename the policy, set `name`
   * to a different value on update.
   */
  @JsonProperty("name")
  private String name;

  /**
   * Full name of the securable on which the policy is defined. Required on create and ignored on
   * update.
   */
  @JsonProperty("on_securable_fullname")
  private String onSecurableFullname;

  /**
   * Type of the securable on which the policy is defined. Only `CATALOG`, `SCHEMA` and `TABLE` are
   * supported at this moment. Required on create and ignored on update.
   */
  @JsonProperty("on_securable_type")
  private SecurableType onSecurableType;

  /** Type of the policy. Required on create and ignored on update. */
  @JsonProperty("policy_type")
  private PolicyType policyType;

  /**
   * Options for row filter policies. Valid only if `policy_type` is `POLICY_TYPE_ROW_FILTER`.
   * Required on create and optional on update. When specified on update, the new options will
   * replace the existing options as a whole.
   */
  @JsonProperty("row_filter")
  private RowFilterOptions rowFilter;

  /**
   * List of user or group names that the policy applies to. Required on create and optional on
   * update.
   */
  @JsonProperty("to_principals")
  private Collection<String> toPrincipals;

  /** Time at which the policy was last modified, in epoch milliseconds. Output only. */
  @JsonProperty("updated_at")
  private Long updatedAt;

  /** Username of the user who last modified the policy. Output only. */
  @JsonProperty("updated_by")
  private String updatedBy;

  /** Optional condition when the policy should take effect. */
  @JsonProperty("when_condition")
  private String whenCondition;

  public PolicyInfo setColumnMask(ColumnMaskOptions columnMask) {
    this.columnMask = columnMask;
    return this;
  }

  public ColumnMaskOptions getColumnMask() {
    return columnMask;
  }

  public PolicyInfo setComment(String comment) {
    this.comment = comment;
    return this;
  }

  public String getComment() {
    return comment;
  }

  public PolicyInfo setCreatedAt(Long createdAt) {
    this.createdAt = createdAt;
    return this;
  }

  public Long getCreatedAt() {
    return createdAt;
  }

  public PolicyInfo setCreatedBy(String createdBy) {
    this.createdBy = createdBy;
    return this;
  }

  public String getCreatedBy() {
    return createdBy;
  }

  public PolicyInfo setExceptPrincipals(Collection<String> exceptPrincipals) {
    this.exceptPrincipals = exceptPrincipals;
    return this;
  }

  public Collection<String> getExceptPrincipals() {
    return exceptPrincipals;
  }

  public PolicyInfo setForSecurableType(SecurableType forSecurableType) {
    this.forSecurableType = forSecurableType;
    return this;
  }

  public SecurableType getForSecurableType() {
    return forSecurableType;
  }

  public PolicyInfo setId(String id) {
    this.id = id;
    return this;
  }

  public String getId() {
    return id;
  }

  public PolicyInfo setMatchColumns(Collection<MatchColumn> matchColumns) {
    this.matchColumns = matchColumns;
    return this;
  }

  public Collection<MatchColumn> getMatchColumns() {
    return matchColumns;
  }

  public PolicyInfo setName(String name) {
    this.name = name;
    return this;
  }

  public String getName() {
    return name;
  }

  public PolicyInfo setOnSecurableFullname(String onSecurableFullname) {
    this.onSecurableFullname = onSecurableFullname;
    return this;
  }

  public String getOnSecurableFullname() {
    return onSecurableFullname;
  }

  public PolicyInfo setOnSecurableType(SecurableType onSecurableType) {
    this.onSecurableType = onSecurableType;
    return this;
  }

  public SecurableType getOnSecurableType() {
    return onSecurableType;
  }

  public PolicyInfo setPolicyType(PolicyType policyType) {
    this.policyType = policyType;
    return this;
  }

  public PolicyType getPolicyType() {
    return policyType;
  }

  public PolicyInfo setRowFilter(RowFilterOptions rowFilter) {
    this.rowFilter = rowFilter;
    return this;
  }

  public RowFilterOptions getRowFilter() {
    return rowFilter;
  }

  public PolicyInfo setToPrincipals(Collection<String> toPrincipals) {
    this.toPrincipals = toPrincipals;
    return this;
  }

  public Collection<String> getToPrincipals() {
    return toPrincipals;
  }

  public PolicyInfo setUpdatedAt(Long updatedAt) {
    this.updatedAt = updatedAt;
    return this;
  }

  public Long getUpdatedAt() {
    return updatedAt;
  }

  public PolicyInfo setUpdatedBy(String updatedBy) {
    this.updatedBy = updatedBy;
    return this;
  }

  public String getUpdatedBy() {
    return updatedBy;
  }

  public PolicyInfo setWhenCondition(String whenCondition) {
    this.whenCondition = whenCondition;
    return this;
  }

  public String getWhenCondition() {
    return whenCondition;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PolicyInfo that = (PolicyInfo) o;
    return Objects.equals(columnMask, that.columnMask)
        && Objects.equals(comment, that.comment)
        && Objects.equals(createdAt, that.createdAt)
        && Objects.equals(createdBy, that.createdBy)
        && Objects.equals(exceptPrincipals, that.exceptPrincipals)
        && Objects.equals(forSecurableType, that.forSecurableType)
        && Objects.equals(id, that.id)
        && Objects.equals(matchColumns, that.matchColumns)
        && Objects.equals(name, that.name)
        && Objects.equals(onSecurableFullname, that.onSecurableFullname)
        && Objects.equals(onSecurableType, that.onSecurableType)
        && Objects.equals(policyType, that.policyType)
        && Objects.equals(rowFilter, that.rowFilter)
        && Objects.equals(toPrincipals, that.toPrincipals)
        && Objects.equals(updatedAt, that.updatedAt)
        && Objects.equals(updatedBy, that.updatedBy)
        && Objects.equals(whenCondition, that.whenCondition);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        columnMask,
        comment,
        createdAt,
        createdBy,
        exceptPrincipals,
        forSecurableType,
        id,
        matchColumns,
        name,
        onSecurableFullname,
        onSecurableType,
        policyType,
        rowFilter,
        toPrincipals,
        updatedAt,
        updatedBy,
        whenCondition);
  }

  @Override
  public String toString() {
    return new ToStringer(PolicyInfo.class)
        .add("columnMask", columnMask)
        .add("comment", comment)
        .add("createdAt", createdAt)
        .add("createdBy", createdBy)
        .add("exceptPrincipals", exceptPrincipals)
        .add("forSecurableType", forSecurableType)
        .add("id", id)
        .add("matchColumns", matchColumns)
        .add("name", name)
        .add("onSecurableFullname", onSecurableFullname)
        .add("onSecurableType", onSecurableType)
        .add("policyType", policyType)
        .add("rowFilter", rowFilter)
        .add("toPrincipals", toPrincipals)
        .add("updatedAt", updatedAt)
        .add("updatedBy", updatedBy)
        .add("whenCondition", whenCondition)
        .toString();
  }
}
