/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core.oauth;

import com.databricks.sdk.core.CredentialsProvider;
import com.databricks.sdk.core.DatabricksConfig;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.core.http.Response;
import com.databricks.sdk.core.oauth.CachedTokenSource;
import com.databricks.sdk.core.oauth.OAuthHeaderFactory;
import com.databricks.sdk.core.oauth.OidcTokenSource;
import com.databricks.sdk.support.InternalApi;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Optional;

@InternalApi
public class AzureGithubOidcCredentialsProvider
implements CredentialsProvider {
    private final ObjectMapper mapper = new ObjectMapper();

    @Override
    public String authType() {
        return "github-oidc-azure";
    }

    @Override
    public OAuthHeaderFactory configure(DatabricksConfig config) {
        if (!config.isAzure() || config.getAzureClientId() == null || config.getAzureTenantId() == null || config.getHost() == null) {
            return null;
        }
        Optional<String> idToken = this.requestIdToken(config);
        if (!idToken.isPresent()) {
            return null;
        }
        OidcTokenSource tokenSource = new OidcTokenSource(config.getHttpClient(), config.getDatabricksEnvironment().getAzureEnvironment().getActiveDirectoryEndpoint() + config.getAzureTenantId() + "/oauth2/token", config.getAzureClientId(), config.getEffectiveAzureLoginAppId(), idToken.get(), "urn:ietf:params:oauth:client-assertion-type:jwt-bearer");
        CachedTokenSource cachedTokenSource = new CachedTokenSource.Builder(tokenSource).setAsyncDisabled(config.getDisableAsyncTokenRefresh()).build();
        return OAuthHeaderFactory.fromTokenSource(cachedTokenSource);
    }

    private Optional<String> requestIdToken(DatabricksConfig config) {
        ObjectNode jsonResp;
        Response resp;
        if (config.getActionsIdTokenRequestUrl() == null || config.getActionsIdTokenRequestToken() == null) {
            return Optional.empty();
        }
        String requestUrl = config.getActionsIdTokenRequestUrl() + "&audience=api://AzureADTokenExchange";
        Request req = new Request("GET", requestUrl).withHeader("Authorization", "Bearer " + config.getActionsIdTokenRequestToken());
        try {
            resp = config.getHttpClient().execute(req);
        }
        catch (IOException e) {
            throw new DatabricksException("Failed to request ID token from " + requestUrl + ":" + e.getMessage(), e);
        }
        if (resp.getStatusCode() != 200) {
            throw new DatabricksException("Failed to request ID token: status code " + resp.getStatusCode() + ", response body: " + resp.getBody().toString());
        }
        try {
            jsonResp = (ObjectNode)this.mapper.readValue(resp.getBody(), ObjectNode.class);
        }
        catch (IOException e) {
            throw new DatabricksException("Failed to request ID token: corrupted token: " + e.getMessage());
        }
        return Optional.ofNullable(jsonResp.get("value").textValue());
    }
}

