/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.catalog;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.catalog.AccountMetastoresImpl;
import com.databricks.sdk.service.catalog.AccountMetastoresService;
import com.databricks.sdk.service.catalog.AccountsCreateMetastore;
import com.databricks.sdk.service.catalog.AccountsCreateMetastoreResponse;
import com.databricks.sdk.service.catalog.AccountsDeleteMetastoreResponse;
import com.databricks.sdk.service.catalog.AccountsGetMetastoreResponse;
import com.databricks.sdk.service.catalog.AccountsListMetastoresResponse;
import com.databricks.sdk.service.catalog.AccountsUpdateMetastore;
import com.databricks.sdk.service.catalog.AccountsUpdateMetastoreResponse;
import com.databricks.sdk.service.catalog.DeleteAccountMetastoreRequest;
import com.databricks.sdk.service.catalog.GetAccountMetastoreRequest;
import com.databricks.sdk.service.catalog.MetastoreInfo;
import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class AccountMetastoresAPI {
    private static final Logger LOG = LoggerFactory.getLogger(AccountMetastoresAPI.class);
    private final AccountMetastoresService impl;

    public AccountMetastoresAPI(ApiClient apiClient) {
        this.impl = new AccountMetastoresImpl(apiClient);
    }

    public AccountMetastoresAPI(AccountMetastoresService mock) {
        this.impl = mock;
    }

    public AccountsCreateMetastoreResponse create(AccountsCreateMetastore request) {
        return this.impl.create(request);
    }

    public AccountsDeleteMetastoreResponse delete(String metastoreId) {
        return this.delete(new DeleteAccountMetastoreRequest().setMetastoreId(metastoreId));
    }

    public AccountsDeleteMetastoreResponse delete(DeleteAccountMetastoreRequest request) {
        return this.impl.delete(request);
    }

    public AccountsGetMetastoreResponse get(String metastoreId) {
        return this.get(new GetAccountMetastoreRequest().setMetastoreId(metastoreId));
    }

    public AccountsGetMetastoreResponse get(GetAccountMetastoreRequest request) {
        return this.impl.get(request);
    }

    public Iterable<MetastoreInfo> list() {
        return new Paginator(null, v -> this.impl.list(), AccountsListMetastoresResponse::getMetastores, response -> null);
    }

    public AccountsUpdateMetastoreResponse update(AccountsUpdateMetastore request) {
        return this.impl.update(request);
    }

    public AccountMetastoresService impl() {
        return this.impl;
    }
}

