/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.catalog;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.service.catalog.CreateFunctionRequest;
import com.databricks.sdk.service.catalog.DeleteFunctionRequest;
import com.databricks.sdk.service.catalog.FunctionInfo;
import com.databricks.sdk.service.catalog.FunctionsService;
import com.databricks.sdk.service.catalog.GetFunctionRequest;
import com.databricks.sdk.service.catalog.ListFunctionsRequest;
import com.databricks.sdk.service.catalog.ListFunctionsResponse;
import com.databricks.sdk.service.catalog.UpdateFunction;
import com.databricks.sdk.support.Generated;
import java.io.IOException;

@Generated
class FunctionsImpl
implements FunctionsService {
    private final ApiClient apiClient;

    public FunctionsImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public FunctionInfo create(CreateFunctionRequest request) {
        String path = "/api/2.1/unity-catalog/functions";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, FunctionInfo.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeleteFunctionRequest request) {
        String path = String.format("/api/2.1/unity-catalog/functions/%s", request.getName());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public FunctionInfo get(GetFunctionRequest request) {
        String path = String.format("/api/2.1/unity-catalog/functions/%s", request.getName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, FunctionInfo.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListFunctionsResponse list(ListFunctionsRequest request) {
        String path = "/api/2.1/unity-catalog/functions";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListFunctionsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public FunctionInfo update(UpdateFunction request) {
        String path = String.format("/api/2.1/unity-catalog/functions/%s", request.getName());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, FunctionInfo.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

