/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.postgres;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.postgres.Branch;
import com.databricks.sdk.service.postgres.CreateBranchOperation;
import com.databricks.sdk.service.postgres.CreateBranchRequest;
import com.databricks.sdk.service.postgres.CreateEndpointOperation;
import com.databricks.sdk.service.postgres.CreateEndpointRequest;
import com.databricks.sdk.service.postgres.CreateProjectOperation;
import com.databricks.sdk.service.postgres.CreateProjectRequest;
import com.databricks.sdk.service.postgres.CreateRoleOperation;
import com.databricks.sdk.service.postgres.CreateRoleRequest;
import com.databricks.sdk.service.postgres.DatabaseCredential;
import com.databricks.sdk.service.postgres.DeleteBranchOperation;
import com.databricks.sdk.service.postgres.DeleteBranchRequest;
import com.databricks.sdk.service.postgres.DeleteEndpointOperation;
import com.databricks.sdk.service.postgres.DeleteEndpointRequest;
import com.databricks.sdk.service.postgres.DeleteProjectOperation;
import com.databricks.sdk.service.postgres.DeleteProjectRequest;
import com.databricks.sdk.service.postgres.DeleteRoleOperation;
import com.databricks.sdk.service.postgres.DeleteRoleRequest;
import com.databricks.sdk.service.postgres.Endpoint;
import com.databricks.sdk.service.postgres.GenerateDatabaseCredentialRequest;
import com.databricks.sdk.service.postgres.GetBranchRequest;
import com.databricks.sdk.service.postgres.GetEndpointRequest;
import com.databricks.sdk.service.postgres.GetOperationRequest;
import com.databricks.sdk.service.postgres.GetProjectRequest;
import com.databricks.sdk.service.postgres.GetRoleRequest;
import com.databricks.sdk.service.postgres.ListBranchesRequest;
import com.databricks.sdk.service.postgres.ListBranchesResponse;
import com.databricks.sdk.service.postgres.ListEndpointsRequest;
import com.databricks.sdk.service.postgres.ListEndpointsResponse;
import com.databricks.sdk.service.postgres.ListProjectsRequest;
import com.databricks.sdk.service.postgres.ListProjectsResponse;
import com.databricks.sdk.service.postgres.ListRolesRequest;
import com.databricks.sdk.service.postgres.ListRolesResponse;
import com.databricks.sdk.service.postgres.Operation;
import com.databricks.sdk.service.postgres.PostgresImpl;
import com.databricks.sdk.service.postgres.PostgresService;
import com.databricks.sdk.service.postgres.Project;
import com.databricks.sdk.service.postgres.Role;
import com.databricks.sdk.service.postgres.UpdateBranchOperation;
import com.databricks.sdk.service.postgres.UpdateBranchRequest;
import com.databricks.sdk.service.postgres.UpdateEndpointOperation;
import com.databricks.sdk.service.postgres.UpdateEndpointRequest;
import com.databricks.sdk.service.postgres.UpdateProjectOperation;
import com.databricks.sdk.service.postgres.UpdateProjectRequest;
import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class PostgresAPI {
    private static final Logger LOG = LoggerFactory.getLogger(PostgresAPI.class);
    private final PostgresService impl;

    public PostgresAPI(ApiClient apiClient) {
        this.impl = new PostgresImpl(apiClient);
    }

    public PostgresAPI(PostgresService mock) {
        this.impl = mock;
    }

    public CreateBranchOperation createBranch(CreateBranchRequest request) {
        Operation operation = this.impl.createBranch(request);
        return new CreateBranchOperation(this.impl, operation);
    }

    public CreateEndpointOperation createEndpoint(CreateEndpointRequest request) {
        Operation operation = this.impl.createEndpoint(request);
        return new CreateEndpointOperation(this.impl, operation);
    }

    public CreateProjectOperation createProject(CreateProjectRequest request) {
        Operation operation = this.impl.createProject(request);
        return new CreateProjectOperation(this.impl, operation);
    }

    public CreateRoleOperation createRole(CreateRoleRequest request) {
        Operation operation = this.impl.createRole(request);
        return new CreateRoleOperation(this.impl, operation);
    }

    public DeleteBranchOperation deleteBranch(String name) {
        return this.deleteBranch(new DeleteBranchRequest().setName(name));
    }

    public DeleteBranchOperation deleteBranch(DeleteBranchRequest request) {
        Operation operation = this.impl.deleteBranch(request);
        return new DeleteBranchOperation(this.impl, operation);
    }

    public DeleteEndpointOperation deleteEndpoint(String name) {
        return this.deleteEndpoint(new DeleteEndpointRequest().setName(name));
    }

    public DeleteEndpointOperation deleteEndpoint(DeleteEndpointRequest request) {
        Operation operation = this.impl.deleteEndpoint(request);
        return new DeleteEndpointOperation(this.impl, operation);
    }

    public DeleteProjectOperation deleteProject(String name) {
        return this.deleteProject(new DeleteProjectRequest().setName(name));
    }

    public DeleteProjectOperation deleteProject(DeleteProjectRequest request) {
        Operation operation = this.impl.deleteProject(request);
        return new DeleteProjectOperation(this.impl, operation);
    }

    public DeleteRoleOperation deleteRole(String name) {
        return this.deleteRole(new DeleteRoleRequest().setName(name));
    }

    public DeleteRoleOperation deleteRole(DeleteRoleRequest request) {
        Operation operation = this.impl.deleteRole(request);
        return new DeleteRoleOperation(this.impl, operation);
    }

    public DatabaseCredential generateDatabaseCredential(GenerateDatabaseCredentialRequest request) {
        return this.impl.generateDatabaseCredential(request);
    }

    public Branch getBranch(String name) {
        return this.getBranch(new GetBranchRequest().setName(name));
    }

    public Branch getBranch(GetBranchRequest request) {
        return this.impl.getBranch(request);
    }

    public Endpoint getEndpoint(String name) {
        return this.getEndpoint(new GetEndpointRequest().setName(name));
    }

    public Endpoint getEndpoint(GetEndpointRequest request) {
        return this.impl.getEndpoint(request);
    }

    public Operation getOperation(String name) {
        return this.getOperation(new GetOperationRequest().setName(name));
    }

    public Operation getOperation(GetOperationRequest request) {
        return this.impl.getOperation(request);
    }

    public Project getProject(String name) {
        return this.getProject(new GetProjectRequest().setName(name));
    }

    public Project getProject(GetProjectRequest request) {
        return this.impl.getProject(request);
    }

    public Role getRole(String name) {
        return this.getRole(new GetRoleRequest().setName(name));
    }

    public Role getRole(GetRoleRequest request) {
        return this.impl.getRole(request);
    }

    public Iterable<Branch> listBranches(String parent) {
        return this.listBranches(new ListBranchesRequest().setParent(parent));
    }

    public Iterable<Branch> listBranches(ListBranchesRequest request) {
        return new Paginator(request, this.impl::listBranches, ListBranchesResponse::getBranches, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public Iterable<Endpoint> listEndpoints(String parent) {
        return this.listEndpoints(new ListEndpointsRequest().setParent(parent));
    }

    public Iterable<Endpoint> listEndpoints(ListEndpointsRequest request) {
        return new Paginator(request, this.impl::listEndpoints, ListEndpointsResponse::getEndpoints, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public Iterable<Project> listProjects(ListProjectsRequest request) {
        return new Paginator(request, this.impl::listProjects, ListProjectsResponse::getProjects, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public Iterable<Role> listRoles(String parent) {
        return this.listRoles(new ListRolesRequest().setParent(parent));
    }

    public Iterable<Role> listRoles(ListRolesRequest request) {
        return new Paginator(request, this.impl::listRoles, ListRolesResponse::getRoles, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public UpdateBranchOperation updateBranch(UpdateBranchRequest request) {
        Operation operation = this.impl.updateBranch(request);
        return new UpdateBranchOperation(this.impl, operation);
    }

    public UpdateEndpointOperation updateEndpoint(UpdateEndpointRequest request) {
        Operation operation = this.impl.updateEndpoint(request);
        return new UpdateEndpointOperation(this.impl, operation);
    }

    public UpdateProjectOperation updateProject(UpdateProjectRequest request) {
        Operation operation = this.impl.updateProject(request);
        return new UpdateProjectOperation(this.impl, operation);
    }

    public PostgresService impl() {
        return this.impl;
    }
}

