/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.sql;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.service.sql.CreateDefaultWarehouseOverrideRequest;
import com.databricks.sdk.service.sql.CreateWarehouseRequest;
import com.databricks.sdk.service.sql.CreateWarehouseResponse;
import com.databricks.sdk.service.sql.DefaultWarehouseOverride;
import com.databricks.sdk.service.sql.DeleteDefaultWarehouseOverrideRequest;
import com.databricks.sdk.service.sql.DeleteWarehouseRequest;
import com.databricks.sdk.service.sql.EditWarehouseRequest;
import com.databricks.sdk.service.sql.GetDefaultWarehouseOverrideRequest;
import com.databricks.sdk.service.sql.GetWarehousePermissionLevelsRequest;
import com.databricks.sdk.service.sql.GetWarehousePermissionLevelsResponse;
import com.databricks.sdk.service.sql.GetWarehousePermissionsRequest;
import com.databricks.sdk.service.sql.GetWarehouseRequest;
import com.databricks.sdk.service.sql.GetWarehouseResponse;
import com.databricks.sdk.service.sql.GetWorkspaceWarehouseConfigResponse;
import com.databricks.sdk.service.sql.ListDefaultWarehouseOverridesRequest;
import com.databricks.sdk.service.sql.ListDefaultWarehouseOverridesResponse;
import com.databricks.sdk.service.sql.ListWarehousesRequest;
import com.databricks.sdk.service.sql.ListWarehousesResponse;
import com.databricks.sdk.service.sql.SetWorkspaceWarehouseConfigRequest;
import com.databricks.sdk.service.sql.StartRequest;
import com.databricks.sdk.service.sql.StopRequest;
import com.databricks.sdk.service.sql.UpdateDefaultWarehouseOverrideRequest;
import com.databricks.sdk.service.sql.WarehousePermissions;
import com.databricks.sdk.service.sql.WarehousePermissionsRequest;
import com.databricks.sdk.service.sql.WarehousesService;
import com.databricks.sdk.support.Generated;
import java.io.IOException;

@Generated
class WarehousesImpl
implements WarehousesService {
    private final ApiClient apiClient;

    public WarehousesImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public CreateWarehouseResponse create(CreateWarehouseRequest request) {
        String path = "/api/2.0/sql/warehouses";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, CreateWarehouseResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public DefaultWarehouseOverride createDefaultWarehouseOverride(CreateDefaultWarehouseOverrideRequest request) {
        String path = "/api/warehouses/v1/default-warehouse-overrides";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request.getDefaultWarehouseOverride()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, DefaultWarehouseOverride.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeleteWarehouseRequest request) {
        String path = String.format("/api/2.0/sql/warehouses/%s", request.getId());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteDefaultWarehouseOverride(DeleteDefaultWarehouseOverrideRequest request) {
        String path = String.format("/api/warehouses/v1/%s", request.getName());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void edit(EditWarehouseRequest request) {
        String path = String.format("/api/2.0/sql/warehouses/%s/edit", request.getId());
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public GetWarehouseResponse get(GetWarehouseRequest request) {
        String path = String.format("/api/2.0/sql/warehouses/%s", request.getId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, GetWarehouseResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public DefaultWarehouseOverride getDefaultWarehouseOverride(GetDefaultWarehouseOverrideRequest request) {
        String path = String.format("/api/warehouses/v1/%s", request.getName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, DefaultWarehouseOverride.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public GetWarehousePermissionLevelsResponse getPermissionLevels(GetWarehousePermissionLevelsRequest request) {
        String path = String.format("/api/2.0/permissions/warehouses/%s/permissionLevels", request.getWarehouseId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, GetWarehousePermissionLevelsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public WarehousePermissions getPermissions(GetWarehousePermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/warehouses/%s", request.getWarehouseId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, WarehousePermissions.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public GetWorkspaceWarehouseConfigResponse getWorkspaceWarehouseConfig() {
        String path = "/api/2.0/sql/config/warehouses";
        try {
            Request req = new Request("GET", path);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, GetWorkspaceWarehouseConfigResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListWarehousesResponse list(ListWarehousesRequest request) {
        String path = "/api/2.0/sql/warehouses";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListWarehousesResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListDefaultWarehouseOverridesResponse listDefaultWarehouseOverrides(ListDefaultWarehouseOverridesRequest request) {
        String path = "/api/warehouses/v1/default-warehouse-overrides";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListDefaultWarehouseOverridesResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public WarehousePermissions setPermissions(WarehousePermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/warehouses/%s", request.getWarehouseId());
        try {
            Request req = new Request("PUT", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, WarehousePermissions.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void setWorkspaceWarehouseConfig(SetWorkspaceWarehouseConfigRequest request) {
        String path = "/api/2.0/sql/config/warehouses";
        try {
            Request req = new Request("PUT", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void start(StartRequest request) {
        String path = String.format("/api/2.0/sql/warehouses/%s/start", request.getId());
        try {
            Request req = new Request("POST", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void stop(StopRequest request) {
        String path = String.format("/api/2.0/sql/warehouses/%s/stop", request.getId());
        try {
            Request req = new Request("POST", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public DefaultWarehouseOverride updateDefaultWarehouseOverride(UpdateDefaultWarehouseOverrideRequest request) {
        String path = String.format("/api/warehouses/v1/%s", request.getName());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request.getDefaultWarehouseOverride()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, DefaultWarehouseOverride.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public WarehousePermissions updatePermissions(WarehousePermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/warehouses/%s", request.getWarehouseId());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, WarehousePermissions.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

