/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core;

import com.databricks.sdk.core.ClientType;
import com.databricks.sdk.core.CredentialsProvider;
import com.databricks.sdk.core.DatabricksConfig;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.HeaderFactory;
import com.databricks.sdk.core.utils.GoogleUtils;
import com.databricks.sdk.support.InternalApi;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.IdTokenCredentials;
import com.google.auth.oauth2.IdTokenProvider;
import com.google.auth.oauth2.ImpersonatedCredentials;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InternalApi
public class GoogleIdCredentialsProvider
implements CredentialsProvider {
    private static final Logger LOG = LoggerFactory.getLogger(GoogleIdCredentialsProvider.class);

    @Override
    public String authType() {
        return "google-id";
    }

    @Override
    public HeaderFactory configure(DatabricksConfig config) {
        GoogleCredentials googleCredentials;
        String host = config.getHost();
        String googleServiceAccount = config.getGoogleServiceAccount();
        if (host == null || googleServiceAccount == null || !config.isGcp()) {
            return null;
        }
        try {
            googleCredentials = GoogleCredentials.getApplicationDefault();
        }
        catch (IOException e) {
            LOG.warn("Failed to get Google application default credential." + e);
            return null;
        }
        ImpersonatedCredentials impersonatedCredentials = ImpersonatedCredentials.create((GoogleCredentials)googleCredentials, (String)googleServiceAccount, null, new ArrayList(), (int)3600);
        IdTokenCredentials idTokenCredentials = IdTokenCredentials.newBuilder().setIdTokenProvider((IdTokenProvider)impersonatedCredentials).setTargetAudience(host).setOptions(Collections.singletonList(IdTokenProvider.Option.INCLUDE_EMAIL)).build();
        ImpersonatedCredentials gcpScopedCredentials = ImpersonatedCredentials.create((GoogleCredentials)googleCredentials, (String)googleServiceAccount, null, GoogleUtils.GCP_SCOPES, (int)3600);
        return () -> {
            HashMap<String, String> headers = new HashMap<String, String>();
            try {
                headers.put("Authorization", String.format("Bearer %s", idTokenCredentials.refreshAccessToken().getTokenValue()));
            }
            catch (IOException e) {
                String message = "Failed to refresh access token from id token credentials.";
                LOG.error(message + e);
                throw new DatabricksException(message, e);
            }
            if (config.getClientType() == ClientType.ACCOUNT) {
                try {
                    headers.put(GoogleUtils.SA_ACCESS_TOKEN_HEADER, gcpScopedCredentials.refreshAccessToken().getTokenValue());
                }
                catch (IOException e) {
                    String message = "Failed to refresh access token from scoped id token credentials.";
                    LOG.error(message + e);
                    throw new DatabricksException(message, e);
                }
            }
            return headers;
        };
    }
}

