/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core.oauth;

import com.databricks.sdk.core.oauth.Token;
import com.databricks.sdk.core.oauth.TokenSource;
import com.databricks.sdk.core.utils.ClockSupplier;
import com.databricks.sdk.core.utils.UtcClockSupplier;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedTokenSource
implements TokenSource {
    private static final Logger logger = LoggerFactory.getLogger(CachedTokenSource.class);
    private static final Duration DEFAULT_STALE_DURATION = Duration.ofMinutes(5L);
    private static final Duration DEFAULT_EXPIRY_BUFFER = Duration.ofSeconds(40L);
    private final TokenSource tokenSource;
    private boolean asyncDisabled = false;
    private final Duration staleDuration;
    private final Duration expiryBuffer;
    private final ClockSupplier clockSupplier;
    protected volatile Token token;
    private boolean refreshInProgress = false;
    private boolean lastRefreshSucceeded = true;

    private CachedTokenSource(Builder builder) {
        this.tokenSource = builder.tokenSource;
        this.asyncDisabled = builder.asyncDisabled;
        this.staleDuration = builder.staleDuration;
        this.expiryBuffer = builder.expiryBuffer;
        this.clockSupplier = builder.clockSupplier;
        this.token = builder.token;
    }

    @Override
    public Token getToken() {
        if (this.asyncDisabled) {
            return this.getTokenBlocking();
        }
        return this.getTokenAsync();
    }

    protected TokenState getTokenState(Token t) {
        if (t == null) {
            return TokenState.EXPIRED;
        }
        Duration lifeTime = Duration.between(Instant.now(this.clockSupplier.getClock()), t.getExpiry());
        if (lifeTime.compareTo(this.expiryBuffer) <= 0) {
            return TokenState.EXPIRED;
        }
        if (lifeTime.compareTo(this.staleDuration) <= 0) {
            return TokenState.STALE;
        }
        return TokenState.FRESH;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Token getTokenBlocking() {
        if (this.getTokenState(this.token) != TokenState.EXPIRED) {
            return this.token;
        }
        CachedTokenSource cachedTokenSource = this;
        synchronized (cachedTokenSource) {
            if (this.getTokenState(this.token) != TokenState.EXPIRED) {
                return this.token;
            }
            this.lastRefreshSucceeded = false;
            try {
                this.token = this.tokenSource.getToken();
            }
            catch (Exception e) {
                logger.error("Failed to refresh token synchronously", (Throwable)e);
                throw e;
            }
            this.lastRefreshSucceeded = true;
            return this.token;
        }
    }

    protected Token getTokenAsync() {
        Token currentToken = this.token;
        switch (this.getTokenState(currentToken)) {
            case FRESH: {
                return currentToken;
            }
            case STALE: {
                this.triggerAsyncRefresh();
                return currentToken;
            }
            case EXPIRED: {
                return this.getTokenBlocking();
            }
        }
        throw new IllegalStateException("Invalid token state.");
    }

    private synchronized void triggerAsyncRefresh() {
        if (!this.refreshInProgress && this.lastRefreshSucceeded && this.getTokenState(this.token) != TokenState.FRESH) {
            this.refreshInProgress = true;
            CompletableFuture.runAsync(() -> {
                try {
                    Token newToken = this.tokenSource.getToken();
                    CachedTokenSource cachedTokenSource = this;
                    synchronized (cachedTokenSource) {
                        this.token = newToken;
                        this.refreshInProgress = false;
                    }
                }
                catch (Exception e) {
                    CachedTokenSource cachedTokenSource = this;
                    synchronized (cachedTokenSource) {
                        this.lastRefreshSucceeded = false;
                        this.refreshInProgress = false;
                        logger.error("Asynchronous token refresh failed", (Throwable)e);
                    }
                }
            });
        }
    }

    static /* synthetic */ Duration access$600() {
        return DEFAULT_STALE_DURATION;
    }

    static /* synthetic */ Duration access$700() {
        return DEFAULT_EXPIRY_BUFFER;
    }

    public static class Builder {
        private final TokenSource tokenSource;
        private boolean asyncDisabled = false;
        private Duration staleDuration = CachedTokenSource.access$600();
        private Duration expiryBuffer = CachedTokenSource.access$700();
        private ClockSupplier clockSupplier = new UtcClockSupplier();
        private Token token;

        public Builder(TokenSource tokenSource) {
            this.tokenSource = Objects.requireNonNull(tokenSource);
        }

        public Builder setToken(Token token) {
            this.token = token;
            return this;
        }

        public Builder setAsyncDisabled(boolean asyncDisabled) {
            this.asyncDisabled = asyncDisabled;
            return this;
        }

        public Builder setStaleDuration(Duration staleDuration) {
            this.staleDuration = staleDuration;
            return this;
        }

        public Builder setExpiryBuffer(Duration expiryBuffer) {
            this.expiryBuffer = expiryBuffer;
            return this;
        }

        public Builder setClockSupplier(ClockSupplier clockSupplier) {
            this.clockSupplier = clockSupplier;
            return this;
        }

        public CachedTokenSource build() {
            return new CachedTokenSource(this);
        }
    }

    private static enum TokenState {
        FRESH,
        STALE,
        EXPIRED;

    }
}

