/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.catalog;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.service.catalog.AccountMetastoresService;
import com.databricks.sdk.service.catalog.AccountsCreateMetastore;
import com.databricks.sdk.service.catalog.AccountsCreateMetastoreResponse;
import com.databricks.sdk.service.catalog.AccountsDeleteMetastoreResponse;
import com.databricks.sdk.service.catalog.AccountsGetMetastoreResponse;
import com.databricks.sdk.service.catalog.AccountsListMetastoresResponse;
import com.databricks.sdk.service.catalog.AccountsUpdateMetastore;
import com.databricks.sdk.service.catalog.AccountsUpdateMetastoreResponse;
import com.databricks.sdk.service.catalog.DeleteAccountMetastoreRequest;
import com.databricks.sdk.service.catalog.GetAccountMetastoreRequest;
import com.databricks.sdk.support.Generated;
import java.io.IOException;

@Generated
class AccountMetastoresImpl
implements AccountMetastoresService {
    private final ApiClient apiClient;

    public AccountMetastoresImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public AccountsCreateMetastoreResponse create(AccountsCreateMetastore request) {
        String path = String.format("/api/2.0/accounts/%s/metastores", this.apiClient.configuredAccountID());
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, AccountsCreateMetastoreResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public AccountsDeleteMetastoreResponse delete(DeleteAccountMetastoreRequest request) {
        String path = String.format("/api/2.0/accounts/%s/metastores/%s", this.apiClient.configuredAccountID(), request.getMetastoreId());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, AccountsDeleteMetastoreResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public AccountsGetMetastoreResponse get(GetAccountMetastoreRequest request) {
        String path = String.format("/api/2.0/accounts/%s/metastores/%s", this.apiClient.configuredAccountID(), request.getMetastoreId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, AccountsGetMetastoreResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public AccountsListMetastoresResponse list() {
        String path = String.format("/api/2.0/accounts/%s/metastores", this.apiClient.configuredAccountID());
        try {
            Request req = new Request("GET", path);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, AccountsListMetastoresResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public AccountsUpdateMetastoreResponse update(AccountsUpdateMetastore request) {
        String path = String.format("/api/2.0/accounts/%s/metastores/%s", this.apiClient.configuredAccountID(), request.getMetastoreId());
        try {
            Request req = new Request("PUT", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, AccountsUpdateMetastoreResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

