/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.postgres;

import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.utils.SerDeUtils;
import com.databricks.sdk.service.common.lro.LroOptions;
import com.databricks.sdk.service.postgres.GetOperationRequest;
import com.databricks.sdk.service.postgres.Operation;
import com.databricks.sdk.service.postgres.PostgresService;
import com.databricks.sdk.service.postgres.ProjectOperationMetadata;
import com.databricks.sdk.support.Generated;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class DeleteProjectOperation {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteProjectOperation.class);
    private final PostgresService impl;
    private Operation operation;
    private final ObjectMapper objectMapper;

    public DeleteProjectOperation(PostgresService impl, Operation operation) {
        this.impl = impl;
        this.operation = operation;
        this.objectMapper = SerDeUtils.createMapper();
    }

    public void waitForCompletion() throws TimeoutException {
        this.waitForCompletion(Optional.empty());
    }

    public void waitForCompletion(Optional<LroOptions> options) throws TimeoutException {
        Optional timeout = options.flatMap(LroOptions::getTimeout);
        long deadline = timeout.isPresent() ? System.currentTimeMillis() + ((Duration)timeout.get()).toMillis() : Long.MAX_VALUE;
        String statusMessage = "polling operation...";
        int attempt = 1;
        while (System.currentTimeMillis() < deadline) {
            this.refreshOperation();
            if (this.operation.getDone() != null && this.operation.getDone().booleanValue()) {
                if (this.operation.getError() != null) {
                    String errorMsg = "unknown error";
                    if (this.operation.getError().getMessage() != null && !this.operation.getError().getMessage().isEmpty()) {
                        errorMsg = this.operation.getError().getMessage();
                    }
                    if (this.operation.getError().getErrorCode() != null) {
                        errorMsg = String.format("[%s] %s", new Object[]{this.operation.getError().getErrorCode(), errorMsg});
                    }
                    throw new DatabricksException("Operation failed: " + errorMsg);
                }
                if (this.operation.getResponse() == null) {
                    throw new DatabricksException("Operation completed but no response available");
                }
                try {
                    JsonNode responseJson = this.objectMapper.valueToTree(this.operation.getResponse());
                    this.objectMapper.treeToValue((TreeNode)responseJson, Void.class);
                }
                catch (JsonProcessingException e) {
                    throw new DatabricksException("Failed to unmarshal  response: " + e.getMessage(), e);
                }
            }
            String prefix = String.format("operation=%s", this.operation.getName());
            int sleep = Math.min(attempt, 10);
            LOG.info("{}: operation in progress (sleeping ~{}s)", (Object)prefix, (Object)sleep);
            try {
                Thread.sleep((long)((double)((long)sleep * 1000L) + Math.random() * 1000.0));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new DatabricksException("Current thread was interrupted", e);
            }
            ++attempt;
        }
        String timeoutMessage = timeout.isPresent() ? String.format("Operation timed out after %s: %s", timeout.get(), statusMessage) : String.format("Operation timed out: %s", statusMessage);
        throw new TimeoutException(timeoutMessage);
    }

    public String getName() {
        return this.operation.getName();
    }

    public ProjectOperationMetadata getMetadata() {
        if (this.operation.getMetadata() == null) {
            return null;
        }
        try {
            JsonNode metadataJson = this.objectMapper.valueToTree(this.operation.getMetadata());
            return (ProjectOperationMetadata)this.objectMapper.treeToValue((TreeNode)metadataJson, ProjectOperationMetadata.class);
        }
        catch (JsonProcessingException e) {
            throw new DatabricksException("Failed to unmarshal operation metadata: " + e.getMessage(), e);
        }
    }

    public boolean isDone() {
        this.refreshOperation();
        return this.operation.getDone() != null && this.operation.getDone() != false;
    }

    private void refreshOperation() {
        this.operation = this.impl.getOperation(new GetOperationRequest().setName(this.operation.getName()));
    }
}

