/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.postgres;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.service.postgres.Branch;
import com.databricks.sdk.service.postgres.CreateBranchRequest;
import com.databricks.sdk.service.postgres.CreateEndpointRequest;
import com.databricks.sdk.service.postgres.CreateProjectRequest;
import com.databricks.sdk.service.postgres.CreateRoleRequest;
import com.databricks.sdk.service.postgres.DatabaseCredential;
import com.databricks.sdk.service.postgres.DeleteBranchRequest;
import com.databricks.sdk.service.postgres.DeleteEndpointRequest;
import com.databricks.sdk.service.postgres.DeleteProjectRequest;
import com.databricks.sdk.service.postgres.DeleteRoleRequest;
import com.databricks.sdk.service.postgres.Endpoint;
import com.databricks.sdk.service.postgres.GenerateDatabaseCredentialRequest;
import com.databricks.sdk.service.postgres.GetBranchRequest;
import com.databricks.sdk.service.postgres.GetEndpointRequest;
import com.databricks.sdk.service.postgres.GetOperationRequest;
import com.databricks.sdk.service.postgres.GetProjectRequest;
import com.databricks.sdk.service.postgres.GetRoleRequest;
import com.databricks.sdk.service.postgres.ListBranchesRequest;
import com.databricks.sdk.service.postgres.ListBranchesResponse;
import com.databricks.sdk.service.postgres.ListEndpointsRequest;
import com.databricks.sdk.service.postgres.ListEndpointsResponse;
import com.databricks.sdk.service.postgres.ListProjectsRequest;
import com.databricks.sdk.service.postgres.ListProjectsResponse;
import com.databricks.sdk.service.postgres.ListRolesRequest;
import com.databricks.sdk.service.postgres.ListRolesResponse;
import com.databricks.sdk.service.postgres.Operation;
import com.databricks.sdk.service.postgres.PostgresService;
import com.databricks.sdk.service.postgres.Project;
import com.databricks.sdk.service.postgres.Role;
import com.databricks.sdk.service.postgres.UpdateBranchRequest;
import com.databricks.sdk.service.postgres.UpdateEndpointRequest;
import com.databricks.sdk.service.postgres.UpdateProjectRequest;
import com.databricks.sdk.support.Generated;
import java.io.IOException;

@Generated
class PostgresImpl
implements PostgresService {
    private final ApiClient apiClient;

    public PostgresImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public Operation createBranch(CreateBranchRequest request) {
        String path = String.format("/api/2.0/postgres/%s/branches", request.getParent());
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request.getBranch()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, Operation.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public Operation createEndpoint(CreateEndpointRequest request) {
        String path = String.format("/api/2.0/postgres/%s/endpoints", request.getParent());
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request.getEndpoint()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, Operation.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public Operation createProject(CreateProjectRequest request) {
        String path = "/api/2.0/postgres/projects";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request.getProject()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, Operation.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public Operation createRole(CreateRoleRequest request) {
        String path = String.format("/api/2.0/postgres/%s/roles", request.getParent());
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request.getRole()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, Operation.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public Operation deleteBranch(DeleteBranchRequest request) {
        String path = String.format("/api/2.0/postgres/%s", request.getName());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, Operation.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public Operation deleteEndpoint(DeleteEndpointRequest request) {
        String path = String.format("/api/2.0/postgres/%s", request.getName());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, Operation.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public Operation deleteProject(DeleteProjectRequest request) {
        String path = String.format("/api/2.0/postgres/%s", request.getName());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, Operation.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public Operation deleteRole(DeleteRoleRequest request) {
        String path = String.format("/api/2.0/postgres/%s", request.getName());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, Operation.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public DatabaseCredential generateDatabaseCredential(GenerateDatabaseCredentialRequest request) {
        String path = "/api/2.0/postgres/credentials";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, DatabaseCredential.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public Branch getBranch(GetBranchRequest request) {
        String path = String.format("/api/2.0/postgres/%s", request.getName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, Branch.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public Endpoint getEndpoint(GetEndpointRequest request) {
        String path = String.format("/api/2.0/postgres/%s", request.getName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, Endpoint.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public Operation getOperation(GetOperationRequest request) {
        String path = String.format("/api/2.0/postgres/%s", request.getName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, Operation.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public Project getProject(GetProjectRequest request) {
        String path = String.format("/api/2.0/postgres/%s", request.getName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, Project.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public Role getRole(GetRoleRequest request) {
        String path = String.format("/api/2.0/postgres/%s", request.getName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, Role.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListBranchesResponse listBranches(ListBranchesRequest request) {
        String path = String.format("/api/2.0/postgres/%s/branches", request.getParent());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListBranchesResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListEndpointsResponse listEndpoints(ListEndpointsRequest request) {
        String path = String.format("/api/2.0/postgres/%s/endpoints", request.getParent());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListEndpointsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListProjectsResponse listProjects(ListProjectsRequest request) {
        String path = "/api/2.0/postgres/projects";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListProjectsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListRolesResponse listRoles(ListRolesRequest request) {
        String path = String.format("/api/2.0/postgres/%s/roles", request.getParent());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListRolesResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public Operation updateBranch(UpdateBranchRequest request) {
        String path = String.format("/api/2.0/postgres/%s", request.getName());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request.getBranch()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, Operation.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public Operation updateEndpoint(UpdateEndpointRequest request) {
        String path = String.format("/api/2.0/postgres/%s", request.getName());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request.getEndpoint()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, Operation.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public Operation updateProject(UpdateProjectRequest request) {
        String path = String.format("/api/2.0/postgres/%s", request.getName());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request.getProject()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, Operation.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

