/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.tags;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.service.tags.CreateTagAssignmentRequest;
import com.databricks.sdk.service.tags.DeleteTagAssignmentRequest;
import com.databricks.sdk.service.tags.GetTagAssignmentRequest;
import com.databricks.sdk.service.tags.ListTagAssignmentsRequest;
import com.databricks.sdk.service.tags.ListTagAssignmentsResponse;
import com.databricks.sdk.service.tags.TagAssignment;
import com.databricks.sdk.service.tags.UpdateTagAssignmentRequest;
import com.databricks.sdk.service.tags.WorkspaceEntityTagAssignmentsService;
import com.databricks.sdk.support.Generated;
import java.io.IOException;

@Generated
class WorkspaceEntityTagAssignmentsImpl
implements WorkspaceEntityTagAssignmentsService {
    private final ApiClient apiClient;

    public WorkspaceEntityTagAssignmentsImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public TagAssignment createTagAssignment(CreateTagAssignmentRequest request) {
        String path = "/api/2.0/entity-tag-assignments";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request.getTagAssignment()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, TagAssignment.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteTagAssignment(DeleteTagAssignmentRequest request) {
        String path = String.format("/api/2.0/entity-tag-assignments/%s/%s/tags/%s", request.getEntityType(), request.getEntityId(), request.getTagKey());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public TagAssignment getTagAssignment(GetTagAssignmentRequest request) {
        String path = String.format("/api/2.0/entity-tag-assignments/%s/%s/tags/%s", request.getEntityType(), request.getEntityId(), request.getTagKey());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, TagAssignment.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListTagAssignmentsResponse listTagAssignments(ListTagAssignmentsRequest request) {
        String path = String.format("/api/2.0/entity-tag-assignments/%s/%s/tags", request.getEntityType(), request.getEntityId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListTagAssignmentsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public TagAssignment updateTagAssignment(UpdateTagAssignmentRequest request) {
        String path = String.format("/api/2.0/entity-tag-assignments/%s/%s/tags/%s", request.getEntityType(), request.getEntityId(), request.getTagKey());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request.getTagAssignment()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, TagAssignment.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

