/*
 * Decompiled with CFR 0.152.
 */
package com.docspring;

import com.docspring.GsonCustomConverterFactory;
import com.docspring.JSON;
import com.docspring.auth.ApiKeyAuth;
import com.docspring.auth.HttpBasicAuth;
import com.docspring.auth.OAuth;
import java.text.DateFormat;
import java.util.LinkedHashMap;
import java.util.Map;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.threeten.bp.format.DateTimeFormatter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.scalars.ScalarsConverterFactory;

public class ApiClient {
    private Map<String, Interceptor> apiAuthorizations = new LinkedHashMap<String, Interceptor>();
    private OkHttpClient.Builder okBuilder;
    private Retrofit.Builder adapterBuilder;
    private JSON json;

    public ApiClient() {
        this.createDefaultAdapter();
    }

    public ApiClient(String[] authNames) {
        this();
        for (String authName : authNames) {
            if (!"api_token_basic".equals(authName)) {
                throw new RuntimeException("auth name \"" + authName + "\" not found in available auth names");
            }
            HttpBasicAuth auth = new HttpBasicAuth();
            this.addAuthorization(authName, auth);
        }
    }

    public ApiClient(String authName) {
        this(new String[]{authName});
    }

    public ApiClient(String authName, String apiKey) {
        this(authName);
        this.setApiKey(apiKey);
    }

    public ApiClient(String authName, String username, String password) {
        this(authName);
        this.setCredentials(username, password);
    }

    public ApiClient(String authName, String clientId, String secret, String username, String password) {
        this(authName);
        this.getTokenEndPoint().setClientId(clientId).setClientSecret(secret).setUsername(username).setPassword(password);
    }

    public void createDefaultAdapter() {
        this.json = new JSON();
        this.okBuilder = new OkHttpClient.Builder();
        String baseUrl = "https://api.docspring.com/api/v1";
        if (!baseUrl.endsWith("/")) {
            baseUrl = baseUrl + "/";
        }
        this.adapterBuilder = new Retrofit.Builder().baseUrl(baseUrl).addConverterFactory((Converter.Factory)ScalarsConverterFactory.create()).addConverterFactory((Converter.Factory)GsonCustomConverterFactory.create(this.json.getGson()));
    }

    public <S> S createService(Class<S> serviceClass) {
        return (S)this.adapterBuilder.client(this.okBuilder.build()).build().create(serviceClass);
    }

    public ApiClient setDateFormat(DateFormat dateFormat) {
        this.json.setDateFormat(dateFormat);
        return this;
    }

    public ApiClient setSqlDateFormat(DateFormat dateFormat) {
        this.json.setSqlDateFormat(dateFormat);
        return this;
    }

    public ApiClient setOffsetDateTimeFormat(DateTimeFormatter dateFormat) {
        this.json.setOffsetDateTimeFormat(dateFormat);
        return this;
    }

    public ApiClient setLocalDateFormat(DateTimeFormatter dateFormat) {
        this.json.setLocalDateFormat(dateFormat);
        return this;
    }

    public ApiClient setApiKey(String apiKey) {
        for (Interceptor apiAuthorization : this.apiAuthorizations.values()) {
            if (!(apiAuthorization instanceof ApiKeyAuth)) continue;
            ApiKeyAuth keyAuth = (ApiKeyAuth)apiAuthorization;
            keyAuth.setApiKey(apiKey);
            return this;
        }
        return this;
    }

    public ApiClient setCredentials(String username, String password) {
        for (Interceptor apiAuthorization : this.apiAuthorizations.values()) {
            if (apiAuthorization instanceof HttpBasicAuth) {
                HttpBasicAuth basicAuth = (HttpBasicAuth)apiAuthorization;
                basicAuth.setCredentials(username, password);
                return this;
            }
            if (!(apiAuthorization instanceof OAuth)) continue;
            OAuth oauth = (OAuth)apiAuthorization;
            oauth.getTokenRequestBuilder().setUsername(username).setPassword(password);
            return this;
        }
        return this;
    }

    public OAuthClientRequest.TokenRequestBuilder getTokenEndPoint() {
        for (Interceptor apiAuthorization : this.apiAuthorizations.values()) {
            if (!(apiAuthorization instanceof OAuth)) continue;
            OAuth oauth = (OAuth)apiAuthorization;
            return oauth.getTokenRequestBuilder();
        }
        return null;
    }

    public OAuthClientRequest.AuthenticationRequestBuilder getAuthorizationEndPoint() {
        for (Interceptor apiAuthorization : this.apiAuthorizations.values()) {
            if (!(apiAuthorization instanceof OAuth)) continue;
            OAuth oauth = (OAuth)apiAuthorization;
            return oauth.getAuthenticationRequestBuilder();
        }
        return null;
    }

    public ApiClient setAccessToken(String accessToken) {
        for (Interceptor apiAuthorization : this.apiAuthorizations.values()) {
            if (!(apiAuthorization instanceof OAuth)) continue;
            OAuth oauth = (OAuth)apiAuthorization;
            oauth.setAccessToken(accessToken);
            return this;
        }
        return this;
    }

    public ApiClient configureAuthorizationFlow(String clientId, String clientSecret, String redirectURI) {
        for (Interceptor apiAuthorization : this.apiAuthorizations.values()) {
            if (!(apiAuthorization instanceof OAuth)) continue;
            OAuth oauth = (OAuth)apiAuthorization;
            oauth.getTokenRequestBuilder().setClientId(clientId).setClientSecret(clientSecret).setRedirectURI(redirectURI);
            oauth.getAuthenticationRequestBuilder().setClientId(clientId).setRedirectURI(redirectURI);
            return this;
        }
        return this;
    }

    public ApiClient registerAccessTokenListener(OAuth.AccessTokenListener accessTokenListener) {
        for (Interceptor apiAuthorization : this.apiAuthorizations.values()) {
            if (!(apiAuthorization instanceof OAuth)) continue;
            OAuth oauth = (OAuth)apiAuthorization;
            oauth.registerAccessTokenListener(accessTokenListener);
            return this;
        }
        return this;
    }

    public ApiClient addAuthorization(String authName, Interceptor authorization) {
        if (this.apiAuthorizations.containsKey(authName)) {
            throw new RuntimeException("auth name \"" + authName + "\" already in api authorizations");
        }
        this.apiAuthorizations.put(authName, authorization);
        this.okBuilder.addInterceptor(authorization);
        return this;
    }

    public Map<String, Interceptor> getApiAuthorizations() {
        return this.apiAuthorizations;
    }

    public ApiClient setApiAuthorizations(Map<String, Interceptor> apiAuthorizations) {
        this.apiAuthorizations = apiAuthorizations;
        return this;
    }

    public Retrofit.Builder getAdapterBuilder() {
        return this.adapterBuilder;
    }

    public ApiClient setAdapterBuilder(Retrofit.Builder adapterBuilder) {
        this.adapterBuilder = adapterBuilder;
        return this;
    }

    public OkHttpClient.Builder getOkBuilder() {
        return this.okBuilder;
    }

    public void addAuthsToOkBuilder(OkHttpClient.Builder okBuilder) {
        for (Interceptor apiAuthorization : this.apiAuthorizations.values()) {
            okBuilder.addInterceptor(apiAuthorization);
        }
    }

    public void configureFromOkclient(OkHttpClient okClient) {
        this.okBuilder = okClient.newBuilder();
        this.addAuthsToOkBuilder(this.okBuilder);
    }
}

