/*
 * Decompiled with CFR 0.152.
 */
package com.docspring;

import com.docspring.AddFieldsData;
import com.docspring.ApiClient;
import com.docspring.ApiException;
import com.docspring.ApiResponse;
import com.docspring.BatchGeneratePdfs201Response;
import com.docspring.CombinePdfsData;
import com.docspring.CombinedSubmission;
import com.docspring.CombinedSubmissionData;
import com.docspring.Configuration;
import com.docspring.CopyTemplateOptions;
import com.docspring.CreateCombinedSubmissionResponse;
import com.docspring.CreateCustomFileData;
import com.docspring.CreateCustomFileResponse;
import com.docspring.CreateFolderData;
import com.docspring.CreateHtmlSubmissionData;
import com.docspring.CreateHtmlTemplate;
import com.docspring.CreatePdfSubmissionData;
import com.docspring.CreatePdfTemplate;
import com.docspring.CreateSubmissionDataRequestEventRequest;
import com.docspring.CreateSubmissionDataRequestEventResponse;
import com.docspring.CreateSubmissionDataRequestResponse;
import com.docspring.CreateSubmissionDataRequestTokenResponse;
import com.docspring.CreateSubmissionResponse;
import com.docspring.Folder;
import com.docspring.JsonSchema;
import com.docspring.ListSubmissionsResponse;
import com.docspring.MoveFolderData;
import com.docspring.MoveTemplateData;
import com.docspring.Pair;
import com.docspring.RenameFolderData;
import com.docspring.Submission;
import com.docspring.SubmissionBatchData;
import com.docspring.SubmissionBatchWithSubmissions;
import com.docspring.SubmissionDataRequestShow;
import com.docspring.SubmissionPreview;
import com.docspring.SuccessErrorResponse;
import com.docspring.SuccessMultipleErrorsResponse;
import com.docspring.Template;
import com.docspring.TemplateAddFieldsResponse;
import com.docspring.TemplatePreview;
import com.docspring.UpdateHtmlTemplate;
import com.docspring.UpdateSubmissionDataRequestData;
import com.docspring.UploadPresignResponse;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.ws.rs.core.GenericType;

public class PdfApi {
    private ApiClient apiClient;

    public PdfApi() {
        this(Configuration.getDefaultApiClient());
    }

    public PdfApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public TemplateAddFieldsResponse addFieldsToTemplate(String templateId, AddFieldsData data) throws ApiException {
        return this.addFieldsToTemplateWithHttpInfo(templateId, data).getData();
    }

    public ApiResponse<TemplateAddFieldsResponse> addFieldsToTemplateWithHttpInfo(String templateId, AddFieldsData data) throws ApiException {
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling addFieldsToTemplate");
        }
        if (data == null) {
            throw new ApiException(400, "Missing the required parameter 'data' when calling addFieldsToTemplate");
        }
        String localVarPath = "/templates/{template_id}/add_fields".replaceAll("\\{template_id}", this.apiClient.escapeString(templateId.toString()));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        String localVarContentType = this.apiClient.selectHeaderContentType("application/json");
        String[] localVarAuthNames = new String[]{"api_token_basic"};
        GenericType<TemplateAddFieldsResponse> localVarReturnType = new GenericType<TemplateAddFieldsResponse>(){};
        return this.apiClient.invokeAPI("PdfApi.addFieldsToTemplate", localVarPath, "PUT", new ArrayList<Pair>(), data, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), new LinkedHashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public BatchGeneratePdfs201Response batchGeneratePdfs(SubmissionBatchData data, Boolean wait) throws ApiException {
        return this.batchGeneratePdfsWithHttpInfo(data, wait).getData();
    }

    public ApiResponse<BatchGeneratePdfs201Response> batchGeneratePdfsWithHttpInfo(SubmissionBatchData data, Boolean wait) throws ApiException {
        if (data == null) {
            throw new ApiException(400, "Missing the required parameter 'data' when calling batchGeneratePdfs");
        }
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>(this.apiClient.parameterToPairs("", "wait", wait));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        String localVarContentType = this.apiClient.selectHeaderContentType("application/json");
        String[] localVarAuthNames = new String[]{"api_token_basic"};
        GenericType<BatchGeneratePdfs201Response> localVarReturnType = new GenericType<BatchGeneratePdfs201Response>(){};
        return this.apiClient.invokeAPI("PdfApi.batchGeneratePdfs", "/submissions/batches", "POST", localVarQueryParams, data, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), new LinkedHashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public CreateCombinedSubmissionResponse combinePdfs(CombinePdfsData data) throws ApiException {
        return this.combinePdfsWithHttpInfo(data).getData();
    }

    public ApiResponse<CreateCombinedSubmissionResponse> combinePdfsWithHttpInfo(CombinePdfsData data) throws ApiException {
        if (data == null) {
            throw new ApiException(400, "Missing the required parameter 'data' when calling combinePdfs");
        }
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        String localVarContentType = this.apiClient.selectHeaderContentType("application/json");
        String[] localVarAuthNames = new String[]{"api_token_basic"};
        GenericType<CreateCombinedSubmissionResponse> localVarReturnType = new GenericType<CreateCombinedSubmissionResponse>(){};
        return this.apiClient.invokeAPI("PdfApi.combinePdfs", "/combined_submissions?v=2", "POST", new ArrayList<Pair>(), data, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), new LinkedHashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public CreateCombinedSubmissionResponse combineSubmissions(CombinedSubmissionData data, Boolean wait) throws ApiException {
        return this.combineSubmissionsWithHttpInfo(data, wait).getData();
    }

    public ApiResponse<CreateCombinedSubmissionResponse> combineSubmissionsWithHttpInfo(CombinedSubmissionData data, Boolean wait) throws ApiException {
        if (data == null) {
            throw new ApiException(400, "Missing the required parameter 'data' when calling combineSubmissions");
        }
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>(this.apiClient.parameterToPairs("", "wait", wait));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        String localVarContentType = this.apiClient.selectHeaderContentType("application/json");
        String[] localVarAuthNames = new String[]{"api_token_basic"};
        GenericType<CreateCombinedSubmissionResponse> localVarReturnType = new GenericType<CreateCombinedSubmissionResponse>(){};
        return this.apiClient.invokeAPI("PdfApi.combineSubmissions", "/combined_submissions", "POST", localVarQueryParams, data, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), new LinkedHashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public TemplatePreview copyTemplate(String templateId, CopyTemplateOptions options) throws ApiException {
        return this.copyTemplateWithHttpInfo(templateId, options).getData();
    }

    public ApiResponse<TemplatePreview> copyTemplateWithHttpInfo(String templateId, CopyTemplateOptions options) throws ApiException {
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling copyTemplate");
        }
        String localVarPath = "/templates/{template_id}/copy".replaceAll("\\{template_id}", this.apiClient.escapeString(templateId.toString()));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        String localVarContentType = this.apiClient.selectHeaderContentType("application/json");
        String[] localVarAuthNames = new String[]{"api_token_basic"};
        GenericType<TemplatePreview> localVarReturnType = new GenericType<TemplatePreview>(){};
        return this.apiClient.invokeAPI("PdfApi.copyTemplate", localVarPath, "POST", new ArrayList<Pair>(), options, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), new LinkedHashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public CreateCustomFileResponse createCustomFileFromUpload(CreateCustomFileData data) throws ApiException {
        return this.createCustomFileFromUploadWithHttpInfo(data).getData();
    }

    public ApiResponse<CreateCustomFileResponse> createCustomFileFromUploadWithHttpInfo(CreateCustomFileData data) throws ApiException {
        if (data == null) {
            throw new ApiException(400, "Missing the required parameter 'data' when calling createCustomFileFromUpload");
        }
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        String localVarContentType = this.apiClient.selectHeaderContentType("application/json");
        String[] localVarAuthNames = new String[]{"api_token_basic"};
        GenericType<CreateCustomFileResponse> localVarReturnType = new GenericType<CreateCustomFileResponse>(){};
        return this.apiClient.invokeAPI("PdfApi.createCustomFileFromUpload", "/custom_files", "POST", new ArrayList<Pair>(), data, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), new LinkedHashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public CreateSubmissionDataRequestEventResponse createDataRequestEvent(String dataRequestId, CreateSubmissionDataRequestEventRequest event) throws ApiException {
        return this.createDataRequestEventWithHttpInfo(dataRequestId, event).getData();
    }

    public ApiResponse<CreateSubmissionDataRequestEventResponse> createDataRequestEventWithHttpInfo(String dataRequestId, CreateSubmissionDataRequestEventRequest event) throws ApiException {
        if (dataRequestId == null) {
            throw new ApiException(400, "Missing the required parameter 'dataRequestId' when calling createDataRequestEvent");
        }
        if (event == null) {
            throw new ApiException(400, "Missing the required parameter 'event' when calling createDataRequestEvent");
        }
        String localVarPath = "/data_requests/{data_request_id}/events".replaceAll("\\{data_request_id}", this.apiClient.escapeString(dataRequestId.toString()));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        String localVarContentType = this.apiClient.selectHeaderContentType("application/json");
        String[] localVarAuthNames = new String[]{"api_token_basic"};
        GenericType<CreateSubmissionDataRequestEventResponse> localVarReturnType = new GenericType<CreateSubmissionDataRequestEventResponse>(){};
        return this.apiClient.invokeAPI("PdfApi.createDataRequestEvent", localVarPath, "POST", new ArrayList<Pair>(), event, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), new LinkedHashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public CreateSubmissionDataRequestTokenResponse createDataRequestToken(String dataRequestId, String type) throws ApiException {
        return this.createDataRequestTokenWithHttpInfo(dataRequestId, type).getData();
    }

    public ApiResponse<CreateSubmissionDataRequestTokenResponse> createDataRequestTokenWithHttpInfo(String dataRequestId, String type) throws ApiException {
        if (dataRequestId == null) {
            throw new ApiException(400, "Missing the required parameter 'dataRequestId' when calling createDataRequestToken");
        }
        String localVarPath = "/data_requests/{data_request_id}/tokens".replaceAll("\\{data_request_id}", this.apiClient.escapeString(dataRequestId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>(this.apiClient.parameterToPairs("", "type", type));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        String localVarContentType = this.apiClient.selectHeaderContentType(new String[0]);
        String[] localVarAuthNames = new String[]{"api_token_basic"};
        GenericType<CreateSubmissionDataRequestTokenResponse> localVarReturnType = new GenericType<CreateSubmissionDataRequestTokenResponse>(){};
        return this.apiClient.invokeAPI("PdfApi.createDataRequestToken", localVarPath, "POST", localVarQueryParams, null, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), new LinkedHashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public Folder createFolder(CreateFolderData data) throws ApiException {
        return this.createFolderWithHttpInfo(data).getData();
    }

    public ApiResponse<Folder> createFolderWithHttpInfo(CreateFolderData data) throws ApiException {
        if (data == null) {
            throw new ApiException(400, "Missing the required parameter 'data' when calling createFolder");
        }
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        String localVarContentType = this.apiClient.selectHeaderContentType("application/json");
        String[] localVarAuthNames = new String[]{"api_token_basic"};
        GenericType<Folder> localVarReturnType = new GenericType<Folder>(){};
        return this.apiClient.invokeAPI("PdfApi.createFolder", "/folders/", "POST", new ArrayList<Pair>(), data, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), new LinkedHashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public TemplatePreview createHTMLTemplate(CreateHtmlTemplate data) throws ApiException {
        return this.createHTMLTemplateWithHttpInfo(data).getData();
    }

    public ApiResponse<TemplatePreview> createHTMLTemplateWithHttpInfo(CreateHtmlTemplate data) throws ApiException {
        if (data == null) {
            throw new ApiException(400, "Missing the required parameter 'data' when calling createHTMLTemplate");
        }
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        String localVarContentType = this.apiClient.selectHeaderContentType("application/json");
        String[] localVarAuthNames = new String[]{"api_token_basic"};
        GenericType<TemplatePreview> localVarReturnType = new GenericType<TemplatePreview>(){};
        return this.apiClient.invokeAPI("PdfApi.createHTMLTemplate", "/templates?endpoint_description=html", "POST", new ArrayList<Pair>(), data, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), new LinkedHashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public TemplatePreview createPDFTemplate(File templateDocument, String templateName, Boolean wait, String templateDescription, String templateParentFolderId) throws ApiException {
        return this.createPDFTemplateWithHttpInfo(templateDocument, templateName, wait, templateDescription, templateParentFolderId).getData();
    }

    public ApiResponse<TemplatePreview> createPDFTemplateWithHttpInfo(File templateDocument, String templateName, Boolean wait, String templateDescription, String templateParentFolderId) throws ApiException {
        if (templateDocument == null) {
            throw new ApiException(400, "Missing the required parameter 'templateDocument' when calling createPDFTemplate");
        }
        if (templateName == null) {
            throw new ApiException(400, "Missing the required parameter 'templateName' when calling createPDFTemplate");
        }
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>(this.apiClient.parameterToPairs("", "wait", wait));
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        localVarFormParams.put("template[document]", templateDocument);
        localVarFormParams.put("template[name]", templateName);
        if (templateDescription != null) {
            localVarFormParams.put("template[description]", templateDescription);
        }
        if (templateParentFolderId != null) {
            localVarFormParams.put("template[parent_folder_id]", templateParentFolderId);
        }
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        String localVarContentType = this.apiClient.selectHeaderContentType("multipart/form-data");
        String[] localVarAuthNames = new String[]{"api_token_basic"};
        GenericType<TemplatePreview> localVarReturnType = new GenericType<TemplatePreview>(){};
        return this.apiClient.invokeAPI("PdfApi.createPDFTemplate", "/templates", "POST", localVarQueryParams, null, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public TemplatePreview createPDFTemplateFromUpload(CreatePdfTemplate data) throws ApiException {
        return this.createPDFTemplateFromUploadWithHttpInfo(data).getData();
    }

    public ApiResponse<TemplatePreview> createPDFTemplateFromUploadWithHttpInfo(CreatePdfTemplate data) throws ApiException {
        if (data == null) {
            throw new ApiException(400, "Missing the required parameter 'data' when calling createPDFTemplateFromUpload");
        }
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        String localVarContentType = this.apiClient.selectHeaderContentType("application/json");
        String[] localVarAuthNames = new String[]{"api_token_basic"};
        GenericType<TemplatePreview> localVarReturnType = new GenericType<TemplatePreview>(){};
        return this.apiClient.invokeAPI("PdfApi.createPDFTemplateFromUpload", "/templates?endpoint_description=cached_upload", "POST", new ArrayList<Pair>(), data, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), new LinkedHashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public Folder deleteFolder(String folderId) throws ApiException {
        return this.deleteFolderWithHttpInfo(folderId).getData();
    }

    public ApiResponse<Folder> deleteFolderWithHttpInfo(String folderId) throws ApiException {
        if (folderId == null) {
            throw new ApiException(400, "Missing the required parameter 'folderId' when calling deleteFolder");
        }
        String localVarPath = "/folders/{folder_id}".replaceAll("\\{folder_id}", this.apiClient.escapeString(folderId.toString()));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        String localVarContentType = this.apiClient.selectHeaderContentType(new String[0]);
        String[] localVarAuthNames = new String[]{"api_token_basic"};
        GenericType<Folder> localVarReturnType = new GenericType<Folder>(){};
        return this.apiClient.invokeAPI("PdfApi.deleteFolder", localVarPath, "DELETE", new ArrayList<Pair>(), null, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), new LinkedHashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public SuccessMultipleErrorsResponse deleteTemplate(String templateId) throws ApiException {
        return this.deleteTemplateWithHttpInfo(templateId).getData();
    }

    public ApiResponse<SuccessMultipleErrorsResponse> deleteTemplateWithHttpInfo(String templateId) throws ApiException {
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling deleteTemplate");
        }
        String localVarPath = "/templates/{template_id}".replaceAll("\\{template_id}", this.apiClient.escapeString(templateId.toString()));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        String localVarContentType = this.apiClient.selectHeaderContentType(new String[0]);
        String[] localVarAuthNames = new String[]{"api_token_basic"};
        GenericType<SuccessMultipleErrorsResponse> localVarReturnType = new GenericType<SuccessMultipleErrorsResponse>(){};
        return this.apiClient.invokeAPI("PdfApi.deleteTemplate", localVarPath, "DELETE", new ArrayList<Pair>(), null, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), new LinkedHashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public CombinedSubmission expireCombinedSubmission(String combinedSubmissionId) throws ApiException {
        return this.expireCombinedSubmissionWithHttpInfo(combinedSubmissionId).getData();
    }

    public ApiResponse<CombinedSubmission> expireCombinedSubmissionWithHttpInfo(String combinedSubmissionId) throws ApiException {
        if (combinedSubmissionId == null) {
            throw new ApiException(400, "Missing the required parameter 'combinedSubmissionId' when calling expireCombinedSubmission");
        }
        String localVarPath = "/combined_submissions/{combined_submission_id}".replaceAll("\\{combined_submission_id}", this.apiClient.escapeString(combinedSubmissionId.toString()));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        String localVarContentType = this.apiClient.selectHeaderContentType(new String[0]);
        String[] localVarAuthNames = new String[]{"api_token_basic"};
        GenericType<CombinedSubmission> localVarReturnType = new GenericType<CombinedSubmission>(){};
        return this.apiClient.invokeAPI("PdfApi.expireCombinedSubmission", localVarPath, "DELETE", new ArrayList<Pair>(), null, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), new LinkedHashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public SubmissionPreview expireSubmission(String submissionId) throws ApiException {
        return this.expireSubmissionWithHttpInfo(submissionId).getData();
    }

    public ApiResponse<SubmissionPreview> expireSubmissionWithHttpInfo(String submissionId) throws ApiException {
        if (submissionId == null) {
            throw new ApiException(400, "Missing the required parameter 'submissionId' when calling expireSubmission");
        }
        String localVarPath = "/submissions/{submission_id}".replaceAll("\\{submission_id}", this.apiClient.escapeString(submissionId.toString()));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        String localVarContentType = this.apiClient.selectHeaderContentType(new String[0]);
        String[] localVarAuthNames = new String[]{"api_token_basic"};
        GenericType<SubmissionPreview> localVarReturnType = new GenericType<SubmissionPreview>(){};
        return this.apiClient.invokeAPI("PdfApi.expireSubmission", localVarPath, "DELETE", new ArrayList<Pair>(), null, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), new LinkedHashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public CreateSubmissionResponse generatePdf(String templateId, CreatePdfSubmissionData submission, Boolean wait) throws ApiException {
        return this.generatePdfWithHttpInfo(templateId, submission, wait).getData();
    }

    public ApiResponse<CreateSubmissionResponse> generatePdfWithHttpInfo(String templateId, CreatePdfSubmissionData submission, Boolean wait) throws ApiException {
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling generatePdf");
        }
        if (submission == null) {
            throw new ApiException(400, "Missing the required parameter 'submission' when calling generatePdf");
        }
        String localVarPath = "/templates/{template_id}/submissions".replaceAll("\\{template_id}", this.apiClient.escapeString(templateId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>(this.apiClient.parameterToPairs("", "wait", wait));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        String localVarContentType = this.apiClient.selectHeaderContentType("application/json");
        String[] localVarAuthNames = new String[]{"api_token_basic"};
        GenericType<CreateSubmissionResponse> localVarReturnType = new GenericType<CreateSubmissionResponse>(){};
        return this.apiClient.invokeAPI("PdfApi.generatePdf", localVarPath, "POST", localVarQueryParams, submission, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), new LinkedHashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public CreateSubmissionResponse generatePdfForHtmlTemplate(String templateId, CreateHtmlSubmissionData submission, Boolean wait) throws ApiException {
        return this.generatePdfForHtmlTemplateWithHttpInfo(templateId, submission, wait).getData();
    }

    public ApiResponse<CreateSubmissionResponse> generatePdfForHtmlTemplateWithHttpInfo(String templateId, CreateHtmlSubmissionData submission, Boolean wait) throws ApiException {
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling generatePdfForHtmlTemplate");
        }
        if (submission == null) {
            throw new ApiException(400, "Missing the required parameter 'submission' when calling generatePdfForHtmlTemplate");
        }
        String localVarPath = "/templates/{template_id}/submissions?endpoint_description=html_templates".replaceAll("\\{template_id}", this.apiClient.escapeString(templateId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>(this.apiClient.parameterToPairs("", "wait", wait));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        String localVarContentType = this.apiClient.selectHeaderContentType("application/json");
        String[] localVarAuthNames = new String[]{"api_token_basic"};
        GenericType<CreateSubmissionResponse> localVarReturnType = new GenericType<CreateSubmissionResponse>(){};
        return this.apiClient.invokeAPI("PdfApi.generatePdfForHtmlTemplate", localVarPath, "POST", localVarQueryParams, submission, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), new LinkedHashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public SuccessErrorResponse generatePreview(String submissionId) throws ApiException {
        return this.generatePreviewWithHttpInfo(submissionId).getData();
    }

    public ApiResponse<SuccessErrorResponse> generatePreviewWithHttpInfo(String submissionId) throws ApiException {
        if (submissionId == null) {
            throw new ApiException(400, "Missing the required parameter 'submissionId' when calling generatePreview");
        }
        String localVarPath = "/submissions/{submission_id}/generate_preview".replaceAll("\\{submission_id}", this.apiClient.escapeString(submissionId.toString()));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        String localVarContentType = this.apiClient.selectHeaderContentType(new String[0]);
        String[] localVarAuthNames = new String[]{"api_token_basic"};
        GenericType<SuccessErrorResponse> localVarReturnType = new GenericType<SuccessErrorResponse>(){};
        return this.apiClient.invokeAPI("PdfApi.generatePreview", localVarPath, "POST", new ArrayList<Pair>(), null, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), new LinkedHashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public CombinedSubmission getCombinedSubmission(String combinedSubmissionId) throws ApiException {
        return this.getCombinedSubmissionWithHttpInfo(combinedSubmissionId).getData();
    }

    public ApiResponse<CombinedSubmission> getCombinedSubmissionWithHttpInfo(String combinedSubmissionId) throws ApiException {
        if (combinedSubmissionId == null) {
            throw new ApiException(400, "Missing the required parameter 'combinedSubmissionId' when calling getCombinedSubmission");
        }
        String localVarPath = "/combined_submissions/{combined_submission_id}".replaceAll("\\{combined_submission_id}", this.apiClient.escapeString(combinedSubmissionId.toString()));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        String localVarContentType = this.apiClient.selectHeaderContentType(new String[0]);
        String[] localVarAuthNames = new String[]{"api_token_basic"};
        GenericType<CombinedSubmission> localVarReturnType = new GenericType<CombinedSubmission>(){};
        return this.apiClient.invokeAPI("PdfApi.getCombinedSubmission", localVarPath, "GET", new ArrayList<Pair>(), null, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), new LinkedHashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public SubmissionDataRequestShow getDataRequest(String dataRequestId) throws ApiException {
        return this.getDataRequestWithHttpInfo(dataRequestId).getData();
    }

    public ApiResponse<SubmissionDataRequestShow> getDataRequestWithHttpInfo(String dataRequestId) throws ApiException {
        if (dataRequestId == null) {
            throw new ApiException(400, "Missing the required parameter 'dataRequestId' when calling getDataRequest");
        }
        String localVarPath = "/data_requests/{data_request_id}".replaceAll("\\{data_request_id}", this.apiClient.escapeString(dataRequestId.toString()));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        String localVarContentType = this.apiClient.selectHeaderContentType(new String[0]);
        String[] localVarAuthNames = new String[]{"api_token_basic"};
        GenericType<SubmissionDataRequestShow> localVarReturnType = new GenericType<SubmissionDataRequestShow>(){};
        return this.apiClient.invokeAPI("PdfApi.getDataRequest", localVarPath, "GET", new ArrayList<Pair>(), null, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), new LinkedHashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public Template getFullTemplate(String templateId) throws ApiException {
        return this.getFullTemplateWithHttpInfo(templateId).getData();
    }

    public ApiResponse<Template> getFullTemplateWithHttpInfo(String templateId) throws ApiException {
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling getFullTemplate");
        }
        String localVarPath = "/templates/{template_id}?full=true".replaceAll("\\{template_id}", this.apiClient.escapeString(templateId.toString()));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        String localVarContentType = this.apiClient.selectHeaderContentType(new String[0]);
        String[] localVarAuthNames = new String[]{"api_token_basic"};
        GenericType<Template> localVarReturnType = new GenericType<Template>(){};
        return this.apiClient.invokeAPI("PdfApi.getFullTemplate", localVarPath, "GET", new ArrayList<Pair>(), null, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), new LinkedHashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public UploadPresignResponse getPresignUrl() throws ApiException {
        return this.getPresignUrlWithHttpInfo().getData();
    }

    public ApiResponse<UploadPresignResponse> getPresignUrlWithHttpInfo() throws ApiException {
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        String localVarContentType = this.apiClient.selectHeaderContentType(new String[0]);
        String[] localVarAuthNames = new String[]{"api_token_basic"};
        GenericType<UploadPresignResponse> localVarReturnType = new GenericType<UploadPresignResponse>(){};
        return this.apiClient.invokeAPI("PdfApi.getPresignUrl", "/uploads/presign", "GET", new ArrayList<Pair>(), null, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), new LinkedHashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public Submission getSubmission(String submissionId, Boolean includeData) throws ApiException {
        return this.getSubmissionWithHttpInfo(submissionId, includeData).getData();
    }

    public ApiResponse<Submission> getSubmissionWithHttpInfo(String submissionId, Boolean includeData) throws ApiException {
        if (submissionId == null) {
            throw new ApiException(400, "Missing the required parameter 'submissionId' when calling getSubmission");
        }
        String localVarPath = "/submissions/{submission_id}".replaceAll("\\{submission_id}", this.apiClient.escapeString(submissionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>(this.apiClient.parameterToPairs("", "include_data", includeData));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        String localVarContentType = this.apiClient.selectHeaderContentType(new String[0]);
        String[] localVarAuthNames = new String[]{"api_token_basic"};
        GenericType<Submission> localVarReturnType = new GenericType<Submission>(){};
        return this.apiClient.invokeAPI("PdfApi.getSubmission", localVarPath, "GET", localVarQueryParams, null, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), new LinkedHashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public SubmissionBatchWithSubmissions getSubmissionBatch(String submissionBatchId, Boolean includeSubmissions) throws ApiException {
        return this.getSubmissionBatchWithHttpInfo(submissionBatchId, includeSubmissions).getData();
    }

    public ApiResponse<SubmissionBatchWithSubmissions> getSubmissionBatchWithHttpInfo(String submissionBatchId, Boolean includeSubmissions) throws ApiException {
        if (submissionBatchId == null) {
            throw new ApiException(400, "Missing the required parameter 'submissionBatchId' when calling getSubmissionBatch");
        }
        String localVarPath = "/submissions/batches/{submission_batch_id}".replaceAll("\\{submission_batch_id}", this.apiClient.escapeString(submissionBatchId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>(this.apiClient.parameterToPairs("", "include_submissions", includeSubmissions));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        String localVarContentType = this.apiClient.selectHeaderContentType(new String[0]);
        String[] localVarAuthNames = new String[]{"api_token_basic"};
        GenericType<SubmissionBatchWithSubmissions> localVarReturnType = new GenericType<SubmissionBatchWithSubmissions>(){};
        return this.apiClient.invokeAPI("PdfApi.getSubmissionBatch", localVarPath, "GET", localVarQueryParams, null, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), new LinkedHashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public TemplatePreview getTemplate(String templateId) throws ApiException {
        return this.getTemplateWithHttpInfo(templateId).getData();
    }

    public ApiResponse<TemplatePreview> getTemplateWithHttpInfo(String templateId) throws ApiException {
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling getTemplate");
        }
        String localVarPath = "/templates/{template_id}".replaceAll("\\{template_id}", this.apiClient.escapeString(templateId.toString()));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        String localVarContentType = this.apiClient.selectHeaderContentType(new String[0]);
        String[] localVarAuthNames = new String[]{"api_token_basic"};
        GenericType<TemplatePreview> localVarReturnType = new GenericType<TemplatePreview>(){};
        return this.apiClient.invokeAPI("PdfApi.getTemplate", localVarPath, "GET", new ArrayList<Pair>(), null, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), new LinkedHashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public JsonSchema getTemplateSchema(String templateId) throws ApiException {
        return this.getTemplateSchemaWithHttpInfo(templateId).getData();
    }

    public ApiResponse<JsonSchema> getTemplateSchemaWithHttpInfo(String templateId) throws ApiException {
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling getTemplateSchema");
        }
        String localVarPath = "/templates/{template_id}/schema".replaceAll("\\{template_id}", this.apiClient.escapeString(templateId.toString()));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        String localVarContentType = this.apiClient.selectHeaderContentType(new String[0]);
        String[] localVarAuthNames = new String[]{"api_token_basic"};
        GenericType<JsonSchema> localVarReturnType = new GenericType<JsonSchema>(){};
        return this.apiClient.invokeAPI("PdfApi.getTemplateSchema", localVarPath, "GET", new ArrayList<Pair>(), null, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), new LinkedHashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public List<CombinedSubmission> listCombinedSubmissions(Integer page, Integer perPage) throws ApiException {
        return this.listCombinedSubmissionsWithHttpInfo(page, perPage).getData();
    }

    public ApiResponse<List<CombinedSubmission>> listCombinedSubmissionsWithHttpInfo(Integer page, Integer perPage) throws ApiException {
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>(this.apiClient.parameterToPairs("", "page", page));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "per_page", perPage));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        String localVarContentType = this.apiClient.selectHeaderContentType(new String[0]);
        String[] localVarAuthNames = new String[]{"api_token_basic"};
        GenericType<List<CombinedSubmission>> localVarReturnType = new GenericType<List<CombinedSubmission>>(){};
        return this.apiClient.invokeAPI("PdfApi.listCombinedSubmissions", "/combined_submissions", "GET", localVarQueryParams, null, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), new LinkedHashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public List<Folder> listFolders(String parentFolderId) throws ApiException {
        return this.listFoldersWithHttpInfo(parentFolderId).getData();
    }

    public ApiResponse<List<Folder>> listFoldersWithHttpInfo(String parentFolderId) throws ApiException {
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>(this.apiClient.parameterToPairs("", "parent_folder_id", parentFolderId));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        String localVarContentType = this.apiClient.selectHeaderContentType(new String[0]);
        String[] localVarAuthNames = new String[]{"api_token_basic"};
        GenericType<List<Folder>> localVarReturnType = new GenericType<List<Folder>>(){};
        return this.apiClient.invokeAPI("PdfApi.listFolders", "/folders/", "GET", localVarQueryParams, null, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), new LinkedHashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public ListSubmissionsResponse listSubmissions(String cursor, BigDecimal limit, String createdAfter, String createdBefore, String type, Boolean includeData) throws ApiException {
        return this.listSubmissionsWithHttpInfo(cursor, limit, createdAfter, createdBefore, type, includeData).getData();
    }

    public ApiResponse<ListSubmissionsResponse> listSubmissionsWithHttpInfo(String cursor, BigDecimal limit, String createdAfter, String createdBefore, String type, Boolean includeData) throws ApiException {
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>(this.apiClient.parameterToPairs("", "cursor", cursor));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "created_after", createdAfter));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "created_before", createdBefore));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "type", type));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include_data", includeData));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        String localVarContentType = this.apiClient.selectHeaderContentType(new String[0]);
        String[] localVarAuthNames = new String[]{"api_token_basic"};
        GenericType<ListSubmissionsResponse> localVarReturnType = new GenericType<ListSubmissionsResponse>(){};
        return this.apiClient.invokeAPI("PdfApi.listSubmissions", "/submissions", "GET", localVarQueryParams, null, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), new LinkedHashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public ListSubmissionsResponse listTemplateSubmissions(String templateId, String cursor, BigDecimal limit, String createdAfter, String createdBefore, String type, Boolean includeData) throws ApiException {
        return this.listTemplateSubmissionsWithHttpInfo(templateId, cursor, limit, createdAfter, createdBefore, type, includeData).getData();
    }

    public ApiResponse<ListSubmissionsResponse> listTemplateSubmissionsWithHttpInfo(String templateId, String cursor, BigDecimal limit, String createdAfter, String createdBefore, String type, Boolean includeData) throws ApiException {
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling listTemplateSubmissions");
        }
        String localVarPath = "/templates/{template_id}/submissions".replaceAll("\\{template_id}", this.apiClient.escapeString(templateId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>(this.apiClient.parameterToPairs("", "cursor", cursor));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "created_after", createdAfter));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "created_before", createdBefore));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "type", type));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include_data", includeData));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        String localVarContentType = this.apiClient.selectHeaderContentType(new String[0]);
        String[] localVarAuthNames = new String[]{"api_token_basic"};
        GenericType<ListSubmissionsResponse> localVarReturnType = new GenericType<ListSubmissionsResponse>(){};
        return this.apiClient.invokeAPI("PdfApi.listTemplateSubmissions", localVarPath, "GET", localVarQueryParams, null, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), new LinkedHashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public List<TemplatePreview> listTemplates(String query, String parentFolderId, Integer page, Integer perPage) throws ApiException {
        return this.listTemplatesWithHttpInfo(query, parentFolderId, page, perPage).getData();
    }

    public ApiResponse<List<TemplatePreview>> listTemplatesWithHttpInfo(String query, String parentFolderId, Integer page, Integer perPage) throws ApiException {
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>(this.apiClient.parameterToPairs("", "query", query));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "parent_folder_id", parentFolderId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page", page));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "per_page", perPage));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        String localVarContentType = this.apiClient.selectHeaderContentType(new String[0]);
        String[] localVarAuthNames = new String[]{"api_token_basic"};
        GenericType<List<TemplatePreview>> localVarReturnType = new GenericType<List<TemplatePreview>>(){};
        return this.apiClient.invokeAPI("PdfApi.listTemplates", "/templates", "GET", localVarQueryParams, null, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), new LinkedHashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public Folder moveFolderToFolder(String folderId, MoveFolderData data) throws ApiException {
        return this.moveFolderToFolderWithHttpInfo(folderId, data).getData();
    }

    public ApiResponse<Folder> moveFolderToFolderWithHttpInfo(String folderId, MoveFolderData data) throws ApiException {
        if (folderId == null) {
            throw new ApiException(400, "Missing the required parameter 'folderId' when calling moveFolderToFolder");
        }
        if (data == null) {
            throw new ApiException(400, "Missing the required parameter 'data' when calling moveFolderToFolder");
        }
        String localVarPath = "/folders/{folder_id}/move".replaceAll("\\{folder_id}", this.apiClient.escapeString(folderId.toString()));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        String localVarContentType = this.apiClient.selectHeaderContentType("application/json");
        String[] localVarAuthNames = new String[]{"api_token_basic"};
        GenericType<Folder> localVarReturnType = new GenericType<Folder>(){};
        return this.apiClient.invokeAPI("PdfApi.moveFolderToFolder", localVarPath, "POST", new ArrayList<Pair>(), data, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), new LinkedHashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public TemplatePreview moveTemplateToFolder(String templateId, MoveTemplateData data) throws ApiException {
        return this.moveTemplateToFolderWithHttpInfo(templateId, data).getData();
    }

    public ApiResponse<TemplatePreview> moveTemplateToFolderWithHttpInfo(String templateId, MoveTemplateData data) throws ApiException {
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling moveTemplateToFolder");
        }
        if (data == null) {
            throw new ApiException(400, "Missing the required parameter 'data' when calling moveTemplateToFolder");
        }
        String localVarPath = "/templates/{template_id}/move".replaceAll("\\{template_id}", this.apiClient.escapeString(templateId.toString()));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        String localVarContentType = this.apiClient.selectHeaderContentType("application/json");
        String[] localVarAuthNames = new String[]{"api_token_basic"};
        GenericType<TemplatePreview> localVarReturnType = new GenericType<TemplatePreview>(){};
        return this.apiClient.invokeAPI("PdfApi.moveTemplateToFolder", localVarPath, "POST", new ArrayList<Pair>(), data, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), new LinkedHashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public Folder renameFolder(String folderId, RenameFolderData data) throws ApiException {
        return this.renameFolderWithHttpInfo(folderId, data).getData();
    }

    public ApiResponse<Folder> renameFolderWithHttpInfo(String folderId, RenameFolderData data) throws ApiException {
        if (folderId == null) {
            throw new ApiException(400, "Missing the required parameter 'folderId' when calling renameFolder");
        }
        if (data == null) {
            throw new ApiException(400, "Missing the required parameter 'data' when calling renameFolder");
        }
        String localVarPath = "/folders/{folder_id}/rename".replaceAll("\\{folder_id}", this.apiClient.escapeString(folderId.toString()));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        String localVarContentType = this.apiClient.selectHeaderContentType("application/json");
        String[] localVarAuthNames = new String[]{"api_token_basic"};
        GenericType<Folder> localVarReturnType = new GenericType<Folder>(){};
        return this.apiClient.invokeAPI("PdfApi.renameFolder", localVarPath, "POST", new ArrayList<Pair>(), data, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), new LinkedHashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public SuccessErrorResponse testAuthentication() throws ApiException {
        return this.testAuthenticationWithHttpInfo().getData();
    }

    public ApiResponse<SuccessErrorResponse> testAuthenticationWithHttpInfo() throws ApiException {
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        String localVarContentType = this.apiClient.selectHeaderContentType(new String[0]);
        String[] localVarAuthNames = new String[]{"api_token_basic"};
        GenericType<SuccessErrorResponse> localVarReturnType = new GenericType<SuccessErrorResponse>(){};
        return this.apiClient.invokeAPI("PdfApi.testAuthentication", "/authentication", "GET", new ArrayList<Pair>(), null, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), new LinkedHashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public CreateSubmissionDataRequestResponse updateDataRequest(String dataRequestId, UpdateSubmissionDataRequestData data) throws ApiException {
        return this.updateDataRequestWithHttpInfo(dataRequestId, data).getData();
    }

    public ApiResponse<CreateSubmissionDataRequestResponse> updateDataRequestWithHttpInfo(String dataRequestId, UpdateSubmissionDataRequestData data) throws ApiException {
        if (dataRequestId == null) {
            throw new ApiException(400, "Missing the required parameter 'dataRequestId' when calling updateDataRequest");
        }
        if (data == null) {
            throw new ApiException(400, "Missing the required parameter 'data' when calling updateDataRequest");
        }
        String localVarPath = "/data_requests/{data_request_id}".replaceAll("\\{data_request_id}", this.apiClient.escapeString(dataRequestId.toString()));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        String localVarContentType = this.apiClient.selectHeaderContentType("application/json");
        String[] localVarAuthNames = new String[]{"api_token_basic"};
        GenericType<CreateSubmissionDataRequestResponse> localVarReturnType = new GenericType<CreateSubmissionDataRequestResponse>(){};
        return this.apiClient.invokeAPI("PdfApi.updateDataRequest", localVarPath, "PUT", new ArrayList<Pair>(), data, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), new LinkedHashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public SuccessMultipleErrorsResponse updateTemplate(String templateId, UpdateHtmlTemplate data) throws ApiException {
        return this.updateTemplateWithHttpInfo(templateId, data).getData();
    }

    public ApiResponse<SuccessMultipleErrorsResponse> updateTemplateWithHttpInfo(String templateId, UpdateHtmlTemplate data) throws ApiException {
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling updateTemplate");
        }
        if (data == null) {
            throw new ApiException(400, "Missing the required parameter 'data' when calling updateTemplate");
        }
        String localVarPath = "/templates/{template_id}".replaceAll("\\{template_id}", this.apiClient.escapeString(templateId.toString()));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        String localVarContentType = this.apiClient.selectHeaderContentType("application/json");
        String[] localVarAuthNames = new String[]{"api_token_basic"};
        GenericType<SuccessMultipleErrorsResponse> localVarReturnType = new GenericType<SuccessMultipleErrorsResponse>(){};
        return this.apiClient.invokeAPI("PdfApi.updateTemplate", localVarPath, "PUT", new ArrayList<Pair>(), data, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), new LinkedHashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }
}

