/*
 * Decompiled with CFR 0.152.
 */
package com.zink.fly.kit;

import com.zink.fly.FlyAccessException;
import java.net.InetAddress;

public class FlyServerRep {
    private static int DEFAULT_FLY_PORT = 4396;
    private String[] flyTags;
    private int flyPort;
    private InetAddress flyAddr;

    FlyServerRep(InetAddress inetAddress, String[] stringArray) {
        this.flyAddr = inetAddress;
        this.flyPort = DEFAULT_FLY_PORT;
        this.flyTags = stringArray;
        this.parseFirstTag(stringArray[0]);
    }

    private void parseFirstTag(String string) {
        if (string != null) {
            try {
                String[] stringArray = string.split("[@:]");
                if (stringArray[1] != null) {
                    this.flyAddr = InetAddress.getByName(stringArray[1]);
                    this.flyTags[0] = stringArray[0];
                }
                if (stringArray[2] != null) {
                    this.setFlyPort(Integer.parseInt(stringArray[2]));
                }
            }
            catch (Exception exception) {
                new FlyAccessException("Malformed first tag in reply from server " + string, exception);
            }
        }
    }

    public InetAddress getFlyAddr() {
        return this.flyAddr;
    }

    public void setFlyAddr(InetAddress inetAddress) {
        this.flyAddr = inetAddress;
    }

    public int getFlyPort() {
        return this.flyPort;
    }

    public void setFlyPort(int n) {
        this.flyPort = n;
    }

    public String[] getFlyTags() {
        return this.flyTags;
    }

    public void setFlyTags(String[] stringArray) {
        this.flyTags = stringArray;
    }

    public boolean tagsMatch(String[] stringArray) {
        if (this.getFlyTags() == null) {
            return false;
        }
        if (stringArray == null) {
            return true;
        }
        for (String string : stringArray) {
            if (this.containsTag(this.flyTags, string)) continue;
            return false;
        }
        return true;
    }

    private boolean containsTag(String[] stringArray, String string) {
        for (String string2 : stringArray) {
            if (!string.equals(string2)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

