/*
 * Decompiled with CFR 0.152.
 */
package com.zink.fly.kit;

import com.zink.fly.FieldCodec;
import com.zink.fly.Fly;
import com.zink.fly.FlyAccessException;
import com.zink.fly.kit.FlyCache;
import com.zink.fly.kit.FlyServerRep;
import com.zink.fly.stub.FlyStub;
import com.zink.fly.stub.SerializingFieldCodec;
import java.util.Collection;

public class FlyFinder {
    private static final int FINDING_SLEEP = 10;
    private static final int FIND_MAX = 11;
    private static final int FIND_ALL_MAX = 21;
    private final FieldCodec fieldCodec;
    private FlyCache cache = new FlyCache();

    public FlyFinder() {
        this(new SerializingFieldCodec());
    }

    public FlyFinder(FieldCodec fieldCodec) {
        this.fieldCodec = fieldCodec;
    }

    public Fly find() {
        FlyStub flyStub = null;
        try {
            this.cache.start();
            Collection<FlyServerRep> collection = this.cache.getAllReps();
            for (int i = 0; collection.isEmpty() && i < 11; ++i) {
                if ((i + 1) % 5 == 0) {
                    this.cache.issueRequest();
                }
                Thread.sleep(10L);
                collection = this.cache.getAllReps();
            }
            if (!collection.isEmpty()) {
                FlyServerRep flyServerRep = (FlyServerRep)collection.toArray()[0];
                flyStub = new FlyStub(flyServerRep.getFlyAddr(), this.fieldCodec);
            }
        }
        catch (Exception exception) {
            throw new FlyAccessException(exception);
        }
        finally {
            this.cache.terminate();
        }
        this.postCheck(flyStub);
        return flyStub;
    }

    private void postCheck(Fly fly) {
        if (fly == null) {
            throw new FlyAccessException("Cannot find Fly");
        }
    }

    public Fly find(String string) {
        return this.find(new String[]{string});
    }

    public Fly find(String[] stringArray) {
        FlyStub flyStub = null;
        try {
            this.cache.start();
            block5: for (int i = 0; flyStub == null && i < 21; ++i) {
                if ((i + 1) % 5 == 0) {
                    this.cache.issueRequest();
                }
                Thread.sleep(10L);
                Collection<FlyServerRep> collection = this.cache.getAllReps();
                for (FlyServerRep flyServerRep : collection) {
                    if (!flyServerRep.tagsMatch(stringArray)) continue;
                    flyStub = new FlyStub(flyServerRep.getFlyAddr(), this.fieldCodec);
                    continue block5;
                }
            }
        }
        catch (Exception exception) {
            throw new FlyAccessException(exception);
        }
        finally {
            this.cache.terminate();
        }
        this.postCheck(flyStub);
        return flyStub;
    }
}

