/*
 * Decompiled with CFR 0.152.
 */
package com.zink.fly.stub;

import com.zink.fly.FieldCodec;
import com.zink.fly.FlyAccessException;
import com.zink.fly.stub.ByteBufferInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;

public class BufferedSerializingFieldCodec
implements FieldCodec {
    private ByteArrayOutputStream baos = null;
    private ObjectOutputStream oos = null;
    private ByteBufferInputStream bbis = null;
    private ObjectInputStream ois = null;

    public BufferedSerializingFieldCodec() {
        this.initStreams();
    }

    private void initStreams() {
        try {
            this.baos = new ByteArrayOutputStream(1048);
            this.oos = new ObjectOutputStream(this.baos);
            this.oos.flush();
            byte[] byArray = this.baos.toByteArray();
            this.baos.reset();
            this.oos.reset();
            this.bbis = new ByteBufferInputStream(ByteBuffer.wrap(byArray));
            this.ois = new ObjectInputStream(this.bbis);
        }
        catch (IOException iOException) {
            throw new FlyAccessException(iOException);
        }
    }

    @Override
    public byte[] writeField(Object object) {
        try {
            this.baos.reset();
            this.oos.writeObject(object);
            this.oos.flush();
            this.oos.reset();
        }
        catch (IOException iOException) {
            throw new FlyAccessException(iOException);
        }
        return this.baos.toByteArray();
    }

    @Override
    public Object readField(byte[] byArray) {
        Object object = null;
        try {
            this.bbis.switchBuffer(ByteBuffer.wrap(byArray));
            object = this.ois.readObject();
        }
        catch (Exception exception) {
            throw new FlyAccessException(exception);
        }
        return object;
    }

    public Object readField(InputStream inputStream) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

