/*
 * Decompiled with CFR 0.152.
 */
package com.github.adchilds.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileUtil {
    public static InputStream getFileInputStream(Object object) throws IOException {
        if (object instanceof String) {
            return new FileInputStream((String)object);
        }
        if (object instanceof File) {
            return new FileInputStream((File)object);
        }
        throw new IOException("Could not convert the given object to an InputStream. object=[" + object + "]");
    }

    public static String readFully(File file) throws IOException {
        if (file == null) {
            return "";
        }
        return FileUtil.readFully(new FileInputStream(file), "UTF-8");
    }

    public static String readFully(InputStream inputStream, String encoding) throws IOException {
        return new String(FileUtil.readFully(inputStream), encoding);
    }

    private static byte[] readFully(InputStream inputStream) throws IOException {
        int length;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = inputStream.read(buffer)) != -1) {
            baos.write(buffer, 0, length);
        }
        return baos.toByteArray();
    }

    private FileUtil() {
    }
}

