/*
 * Decompiled with CFR 0.152.
 */
package com.github.adchilds.jython;

import com.github.adchilds.jython.exception.JythonResultNotFoundException;
import com.github.adchilds.jython.exception.JythonScriptException;
import com.github.adchilds.jython.exception.JythonScriptNotFoundException;
import com.github.adchilds.util.FileUtil;
import com.github.adchilds.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.python.core.Py;
import org.python.core.PyBoolean;
import org.python.core.PyCode;
import org.python.core.PyDictionary;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PySet;
import org.python.core.PyString;
import org.python.core.PySystemState;
import org.python.util.PythonInterpreter;

public class JythonScript {
    private static PythonInterpreter INTERPRETER = new PythonInterpreter();
    private static final String EVALUATION_RESULT_LOCAL_VARIABLE = "result";

    public static PyCode compile(String filePath) throws JythonScriptException {
        if (StringUtil.isBlank(filePath)) {
            throw new JythonScriptException("Null or empty path is not a file.");
        }
        return JythonScript.compile(new File(filePath));
    }

    public static PyCode compile(URL fileUrl) throws JythonScriptException {
        File file;
        if (fileUrl == null) {
            throw new JythonScriptException("Null path is not a URL.");
        }
        try {
            file = new File(fileUrl.toURI());
        }
        catch (Exception e) {
            throw new JythonScriptException("Could not convert URL to File.", e);
        }
        return JythonScript.compile(file);
    }

    public static PyCode compile(File file) throws JythonScriptException {
        if (file == null) {
            throw new JythonScriptException("Given file is null; cannot be compiled into PyCode.");
        }
        if (!file.isFile()) {
            throw new JythonScriptException("Given file object is not a file. Is it a directory? file=[" + file.getAbsolutePath() + "]");
        }
        try {
            return JythonScript.compileString(FileUtil.readFully(file));
        }
        catch (IOException e) {
            throw new JythonScriptException("Could not compile the given file. file=[" + file.getAbsolutePath() + "]", e);
        }
    }

    public static PyCode compileString(String script) throws JythonScriptException {
        if (StringUtil.isBlank(script)) {
            throw new JythonScriptException("Given script was null or empty; cannot be compiled into PyCode.");
        }
        return INTERPRETER.compile(script);
    }

    public static Object evaluate(String scriptPath, Object ... args) throws JythonScriptException {
        InputStream inputStream;
        if (StringUtil.isBlank(scriptPath)) {
            throw new JythonScriptNotFoundException("File not found at path=[" + scriptPath + "]");
        }
        try {
            inputStream = FileUtil.getFileInputStream(scriptPath);
        }
        catch (Exception e) {
            throw new JythonScriptNotFoundException("Could not open Jython script from location=[" + scriptPath + "]", e);
        }
        return JythonScript.evaluate(inputStream, args);
    }

    public static Object evaluate(URL scriptUrl, Object ... args) throws JythonScriptException {
        InputStream inputStream;
        File file;
        if (scriptUrl == null) {
            throw new JythonScriptException("Null path is not a URL.");
        }
        try {
            file = new File(scriptUrl.toURI());
        }
        catch (Exception e) {
            throw new JythonScriptException("Could not convert URL to File.", e);
        }
        try {
            inputStream = FileUtil.getFileInputStream(file);
        }
        catch (Exception e) {
            throw new JythonScriptNotFoundException("Could not open Jython script from location=[" + scriptUrl.getPath() + "]", e);
        }
        return JythonScript.evaluate(inputStream, args);
    }

    public static Object evaluate(File scriptFile, Object ... args) throws JythonScriptException {
        InputStream inputStream;
        if (scriptFile == null) {
            throw new JythonScriptNotFoundException("Could not open Jython script, the file was null.");
        }
        try {
            inputStream = FileUtil.getFileInputStream(scriptFile);
        }
        catch (Exception e) {
            throw new JythonScriptNotFoundException("Could not open Jython script from location=[" + scriptFile.getAbsolutePath() + "]", e);
        }
        return JythonScript.evaluate(inputStream, args);
    }

    public static Object evaluate(InputStream inputStream, Object ... args) throws JythonScriptException {
        JythonScript.execute(inputStream, args);
        PyObject result = INTERPRETER.get(EVALUATION_RESULT_LOCAL_VARIABLE);
        if (result == null) {
            throw new JythonResultNotFoundException("Local variable 'result' not found during script execution.");
        }
        return JythonScript.parseResult(result);
    }

    public static Object evaluate(PyCode pyCode, Object ... args) throws JythonScriptException {
        JythonScript.execute(pyCode, args);
        PyObject result = INTERPRETER.get(EVALUATION_RESULT_LOCAL_VARIABLE);
        if (result == null) {
            throw new JythonResultNotFoundException("Local variable 'result' not found during script execution.");
        }
        return JythonScript.parseResult(result);
    }

    public static void execute(String scriptPath, Object ... args) throws JythonScriptException {
        InputStream inputStream;
        if (StringUtil.isBlank(scriptPath)) {
            throw new JythonScriptNotFoundException("File not found at path=[" + scriptPath + "]");
        }
        try {
            inputStream = FileUtil.getFileInputStream(scriptPath);
        }
        catch (Exception e) {
            throw new JythonScriptNotFoundException("Could not open Jython script from location=[" + scriptPath + "]", e);
        }
        JythonScript.execute(inputStream, args);
    }

    public static void execute(URL scriptUrl, Object ... args) throws JythonScriptException {
        InputStream inputStream;
        File file;
        if (scriptUrl == null) {
            throw new JythonScriptException("Null path is not a URL.");
        }
        try {
            file = new File(scriptUrl.toURI());
        }
        catch (Exception e) {
            throw new JythonScriptException("Could not convert URL to File.", e);
        }
        try {
            inputStream = FileUtil.getFileInputStream(file);
        }
        catch (Exception e) {
            throw new JythonScriptNotFoundException("Could not open Jython script from location=[" + scriptUrl.getPath() + "]", e);
        }
        JythonScript.execute(inputStream, args);
    }

    public static void execute(File scriptFile, Object ... args) throws JythonScriptException {
        InputStream inputStream;
        if (scriptFile == null) {
            throw new JythonScriptNotFoundException("Could not open Jython script, the file was null.");
        }
        try {
            inputStream = FileUtil.getFileInputStream(scriptFile);
        }
        catch (Exception e) {
            throw new JythonScriptNotFoundException("Could not open Jython script from location=[" + scriptFile.getAbsolutePath() + "]", e);
        }
        JythonScript.execute(inputStream, args);
    }

    public static void execute(InputStream inputStream, Object ... args) throws JythonScriptException {
        if (inputStream == null) {
            throw new JythonScriptException("Cannot execute a Jython script that doesn't exist! InputStream is null.");
        }
        JythonScript.updateInterpreterState(args);
        try {
            INTERPRETER.execfile(inputStream);
        }
        catch (Exception e) {
            throw new JythonScriptException("An error occurred during script execution. cause=[\n\t" + e.toString() + "]");
        }
    }

    public static void execute(PyCode pyCode, Object ... args) throws JythonScriptException {
        if (pyCode == null) {
            throw new JythonScriptException("Cannot execute a Jython script that doesn't exist! InputStream is null.");
        }
        JythonScript.updateInterpreterState(args);
        try {
            INTERPRETER.exec((PyObject)pyCode);
        }
        catch (Exception e) {
            throw new JythonScriptException("An error occurred during script execution. cause=[\n\t" + e.toString() + "]");
        }
    }

    private static void updateInterpreterState(Object ... args) {
        PySystemState state = JythonScript.parseArguments(args);
        INTERPRETER = new PythonInterpreter(null, state);
    }

    private static PySystemState parseArguments(Object ... args) {
        PySystemState systemState = new PySystemState();
        for (Object arg : args) {
            systemState.argv.append(Py.java2py((Object)arg));
        }
        return systemState;
    }

    private static Object parseResult(PyObject object) {
        if (object == null) {
            return null;
        }
        if (object instanceof PyBoolean) {
            return Py.py2boolean((PyObject)object);
        }
        if (object instanceof PyInteger) {
            return Py.py2int((PyObject)object);
        }
        if (object instanceof PyString) {
            return ((PyString)object).getString();
        }
        if (object instanceof PyFloat) {
            return Float.valueOf(Py.py2float((PyObject)object));
        }
        if (object instanceof PyLong) {
            return Py.py2long((PyObject)object);
        }
        if (object instanceof PyList) {
            return JythonScript.parsePyObjectList(((PyList)object).getArray());
        }
        if (object instanceof PyDictionary) {
            return JythonScript.parsePyObjectDict(((PyDictionary)object).getMap());
        }
        if (object instanceof PySet) {
            return JythonScript.parsePyObjectSet(((PySet)object).getSet());
        }
        return object;
    }

    private static Object[] parsePyObjectList(PyObject[] pyObjects) {
        Object[] objects = new Object[pyObjects.length];
        int index = 0;
        for (PyObject pyObject : pyObjects) {
            objects[index] = JythonScript.parseResult(pyObject);
            ++index;
        }
        return objects;
    }

    private static Map<Object, Object> parsePyObjectDict(Map<PyObject, PyObject> pyDict) {
        HashMap<Object, Object> objects = new HashMap<Object, Object>();
        for (Map.Entry<PyObject, PyObject> entry : pyDict.entrySet()) {
            Object key = JythonScript.parseResult(entry.getKey());
            Object value = JythonScript.parseResult(entry.getValue());
            objects.put(key, value);
        }
        return objects;
    }

    private static Set<Object> parsePyObjectSet(Set<PyObject> pySet) {
        HashSet<Object> objects = new HashSet<Object>();
        for (PyObject pyObject : pySet) {
            objects.add(JythonScript.parseResult(pyObject));
        }
        return objects;
    }

    private JythonScript() {
    }
}

