/*
 * Decompiled with CFR 0.152.
 */
package com.github.aivancioglo.resttest.http;

import com.github.aivancioglo.resttest.http.OAuth1;
import com.github.aivancioglo.resttest.http.OAuth2;
import com.github.aivancioglo.resttest.http.Response;
import com.github.aivancioglo.resttest.http.ResponseImpl;
import com.github.aivancioglo.resttest.http.Settings;
import com.github.aivancioglo.resttest.setters.Setter;
import io.restassured.RestAssured;
import io.restassured.http.Method;
import io.restassured.internal.RequestSpecificationImpl;
import io.restassured.response.ResponseOptions;
import io.restassured.specification.RequestSpecification;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 %2\u00020\u0001:\u0001%B\u0005\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0012\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001e0\u001d\"\u00020\u001eH\u0004\u00a2\u0006\u0002\u0010\u001fJ1\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u00042\u0012\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001e0\u001d\"\u00020\u001eH\u0004\u00a2\u0006\u0002\u0010!J!\u0010\"\u001a\u00020#2\u0012\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001e0\u001d\"\u00020\u001eH\u0004\u00a2\u0006\u0002\u0010$R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0006\"\u0004\b\u0013\u0010\bR\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006&"}, d2={"Lcom/github/aivancioglo/resttest/http/Request;", "", "()V", "host", "", "getHost", "()Ljava/lang/String;", "setHost", "(Ljava/lang/String;)V", "oAuth1", "Lcom/github/aivancioglo/resttest/http/OAuth1;", "getOAuth1", "()Lcom/github/aivancioglo/resttest/http/OAuth1;", "oAuth2", "Lcom/github/aivancioglo/resttest/http/OAuth2;", "getOAuth2", "()Lcom/github/aivancioglo/resttest/http/OAuth2;", "protocol", "getProtocol", "setProtocol", "requestSpecification", "Lio/restassured/specification/RequestSpecification;", "getRequestSpecification", "()Lio/restassured/specification/RequestSpecification;", "send", "Lcom/github/aivancioglo/resttest/http/Response;", "method", "Lio/restassured/http/Method;", "setters", "", "Lcom/github/aivancioglo/resttest/setters/Setter;", "(Lio/restassured/http/Method;[Lcom/github/aivancioglo/resttest/setters/Setter;)Lcom/github/aivancioglo/resttest/http/Response;", "path", "(Lio/restassured/http/Method;Ljava/lang/String;[Lcom/github/aivancioglo/resttest/setters/Setter;)Lcom/github/aivancioglo/resttest/http/Response;", "set", "", "([Lcom/github/aivancioglo/resttest/setters/Setter;)V", "Companion", "resttest-java"})
public class Request {
    @NotNull
    private final RequestSpecification requestSpecification;
    @NotNull
    private final OAuth1 oAuth1;
    @NotNull
    private final OAuth2 oAuth2;
    @NotNull
    private String protocol;
    @NotNull
    private String host;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final RequestSpecification getRequestSpecification() {
        return this.requestSpecification;
    }

    @NotNull
    public final OAuth1 getOAuth1() {
        return this.oAuth1;
    }

    @NotNull
    public final OAuth2 getOAuth2() {
        return this.oAuth2;
    }

    @NotNull
    public final String getProtocol() {
        return this.protocol;
    }

    public final void setProtocol(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.protocol = string;
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    public final void setHost(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.host = string;
    }

    protected final void set(Setter ... setters) {
        Intrinsics.checkParameterIsNotNull((Object)setters, (String)"setters");
        for (Setter setter : setters) {
            setter.update(this);
        }
    }

    @NotNull
    protected final Response send(@NotNull Method method, Setter ... setters) {
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        Intrinsics.checkParameterIsNotNull((Object)setters, (String)"setters");
        for (Setter setter : setters) {
            setter.update(this);
        }
        if (this.oAuth1.getUsed() && this.oAuth2.getUsed()) {
            throw (Throwable)new RuntimeException("You can not use OAuth 1.0 and OAuth 2 in the same request!");
        }
        if (this.oAuth1.getUsed()) {
            this.requestSpecification.auth().oauth(this.oAuth1.getConsumerKey(), this.oAuth1.getConsumerSecret(), this.oAuth1.getToken(), this.oAuth1.getTokenSecret());
        }
        if (this.oAuth2.getUsed()) {
            this.requestSpecification.auth().oauth2(this.oAuth2.getToken());
        }
        this.requestSpecification.baseUri("" + this.protocol + "://" + this.host);
        RequestSpecification requestSpecification = this.requestSpecification;
        if (requestSpecification == null) {
            throw new TypeCastException("null cannot be cast to non-null type io.restassured.internal.RequestSpecificationImpl");
        }
        RequestSpecificationImpl requestSpecificationImpl = (RequestSpecificationImpl)requestSpecification;
        ResponseOptions responseOptions = this.requestSpecification.request(method);
        if (responseOptions == null) {
            Intrinsics.throwNpe();
        }
        return new ResponseImpl(requestSpecificationImpl, (io.restassured.response.Response)responseOptions);
    }

    @NotNull
    protected final Response send(@NotNull Method method, @NotNull String path2, Setter ... setters) {
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        Intrinsics.checkParameterIsNotNull((Object)path2, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)setters, (String)"setters");
        for (Setter setter : setters) {
            setter.update(this);
        }
        if (this.oAuth1.getUsed() && this.oAuth2.getUsed()) {
            throw (Throwable)new RuntimeException("You can not use OAuth 1.0 and OAuth 2 in the same request!");
        }
        if (this.oAuth1.getUsed()) {
            this.requestSpecification.auth().oauth(this.oAuth1.getConsumerKey(), this.oAuth1.getConsumerSecret(), this.oAuth1.getToken(), this.oAuth1.getTokenSecret());
        }
        if (this.oAuth2.getUsed()) {
            this.requestSpecification.auth().oauth2(this.oAuth2.getToken());
        }
        this.requestSpecification.baseUri("" + this.protocol + "://" + this.host);
        RequestSpecification requestSpecification = this.requestSpecification;
        if (requestSpecification == null) {
            throw new TypeCastException("null cannot be cast to non-null type io.restassured.internal.RequestSpecificationImpl");
        }
        RequestSpecificationImpl requestSpecificationImpl = (RequestSpecificationImpl)requestSpecification;
        ResponseOptions responseOptions = this.requestSpecification.request(method, path2, new Object[0]);
        if (responseOptions == null) {
            Intrinsics.throwNpe();
        }
        return new ResponseImpl(requestSpecificationImpl, (io.restassured.response.Response)responseOptions);
    }

    public Request() {
        RequestSpecification requestSpecification = RestAssured.given().contentType(Settings.Companion.getContentType());
        if (requestSpecification == null) {
            Intrinsics.throwNpe();
        }
        this.requestSpecification = requestSpecification;
        this.oAuth1 = new OAuth1();
        this.oAuth2 = new OAuth2();
        this.protocol = "http";
        this.host = "";
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/github/aivancioglo/resttest/http/Request$Companion;", "", "()V", "resttest-java"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

