/*
 * Decompiled with CFR 0.152.
 */
package com.github.aivancioglo.resttest.http;

import com.github.aivancioglo.resttest.http.OAuth1;
import com.github.aivancioglo.resttest.http.OAuth2;
import com.github.aivancioglo.resttest.http.Response;
import com.github.aivancioglo.resttest.http.ResponseImpl;
import com.github.aivancioglo.resttest.http.Settings;
import com.github.aivancioglo.resttest.logger.RequestLogger;
import com.github.aivancioglo.resttest.setters.Setter;
import io.restassured.RestAssured;
import io.restassured.http.Method;
import io.restassured.internal.RequestSpecificationImpl;
import io.restassured.response.ResponseOptions;
import io.restassured.specification.RequestSpecification;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 82\u00020\u0001:\u00018B\u0005\u00a2\u0006\u0002\u0010\u0002J)\u0010,\u001a\u00020-2\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010&\u001a\n\u0012\u0006\b\u0001\u0012\u00020(0.\"\u00020(H\u0004\u00a2\u0006\u0002\u0010/J1\u0010,\u001a\u00020-2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u00100\u001a\u00020\u00052\u0012\u0010&\u001a\n\u0012\u0006\b\u0001\u0012\u00020(0.\"\u00020(H\u0004\u00a2\u0006\u0002\u00101J!\u00102\u001a\u0002032\u0012\u0010&\u001a\n\u0012\u0006\b\u0001\u0012\u00020(0.\"\u00020(H\u0004\u00a2\u0006\u0002\u00104J\b\u00105\u001a\u000203H\u0002J\u0014\u0010\u0015\u001a\u000203*\u0002062\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0014\u00107\u001a\u000203*\u0002062\u0006\u00100\u001a\u00020\u0005H\u0002R-\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0001`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u001a\u0010\u0011\u001a\u00020\u0012X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u000b\"\u0004\b!\u0010\rR\u0011\u0010\"\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R!\u0010&\u001a\u0012\u0012\u0004\u0012\u00020(0'j\b\u0012\u0004\u0012\u00020(`)\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+\u00a8\u00069"}, d2={"Lcom/github/aivancioglo/resttest/http/Request;", "", "()V", "body", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "getBody", "()Ljava/util/HashMap;", "contentType", "getContentType", "()Ljava/lang/String;", "setContentType", "(Ljava/lang/String;)V", "host", "getHost", "setHost", "method", "Lio/restassured/http/Method;", "getMethod", "()Lio/restassured/http/Method;", "setMethod", "(Lio/restassured/http/Method;)V", "oAuth1", "Lcom/github/aivancioglo/resttest/http/OAuth1;", "getOAuth1", "()Lcom/github/aivancioglo/resttest/http/OAuth1;", "oAuth2", "Lcom/github/aivancioglo/resttest/http/OAuth2;", "getOAuth2", "()Lcom/github/aivancioglo/resttest/http/OAuth2;", "protocol", "getProtocol", "setProtocol", "requestSpecification", "Lio/restassured/specification/RequestSpecification;", "getRequestSpecification", "()Lio/restassured/specification/RequestSpecification;", "setters", "Ljava/util/ArrayList;", "Lcom/github/aivancioglo/resttest/setters/Setter;", "Lkotlin/collections/ArrayList;", "getSetters", "()Ljava/util/ArrayList;", "send", "Lcom/github/aivancioglo/resttest/http/Response;", "", "(Lio/restassured/http/Method;[Lcom/github/aivancioglo/resttest/setters/Setter;)Lcom/github/aivancioglo/resttest/http/Response;", "path", "(Lio/restassured/http/Method;Ljava/lang/String;[Lcom/github/aivancioglo/resttest/setters/Setter;)Lcom/github/aivancioglo/resttest/http/Response;", "set", "", "([Lcom/github/aivancioglo/resttest/setters/Setter;)V", "update", "Lio/restassured/internal/RequestSpecificationImpl;", "setPath", "Companion", "resttest-java"})
public class Request {
    @NotNull
    private final RequestSpecification requestSpecification;
    @NotNull
    private final OAuth1 oAuth1;
    @NotNull
    private final OAuth2 oAuth2;
    @NotNull
    private String contentType;
    @NotNull
    private final HashMap<String, Object> body;
    @NotNull
    private final ArrayList<Setter> setters;
    @NotNull
    public Method method;
    @NotNull
    private String protocol;
    @NotNull
    private String host;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final RequestSpecification getRequestSpecification() {
        return this.requestSpecification;
    }

    @NotNull
    public final OAuth1 getOAuth1() {
        return this.oAuth1;
    }

    @NotNull
    public final OAuth2 getOAuth2() {
        return this.oAuth2;
    }

    @NotNull
    public final String getContentType() {
        return this.contentType;
    }

    public final void setContentType(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.contentType = string;
    }

    @NotNull
    public final HashMap<String, Object> getBody() {
        return this.body;
    }

    @NotNull
    public final ArrayList<Setter> getSetters() {
        return this.setters;
    }

    @NotNull
    public final Method getMethod() {
        Method method = this.method;
        if (method == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"method");
        }
        return method;
    }

    public final void setMethod(@NotNull Method method) {
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"<set-?>");
        this.method = method;
    }

    @NotNull
    public final String getProtocol() {
        return this.protocol;
    }

    public final void setProtocol(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.protocol = string;
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    public final void setHost(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.host = string;
    }

    protected final void set(Setter ... setters) {
        Intrinsics.checkParameterIsNotNull((Object)setters, (String)"setters");
        for (Setter setter : setters) {
            this.setters.add(setter);
        }
    }

    @NotNull
    protected final Response send(@NotNull Method method, Setter ... setters) {
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        Intrinsics.checkParameterIsNotNull((Object)setters, (String)"setters");
        return this.send(method, "", Arrays.copyOf(setters, setters.length));
    }

    @NotNull
    protected final Response send(@NotNull Method method, @NotNull String path2, Setter ... setters) {
        io.restassured.response.Response response;
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        Intrinsics.checkParameterIsNotNull((Object)path2, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)setters, (String)"setters");
        this.method = method;
        CollectionsKt.addAll((Collection)this.setters, (Object[])setters);
        this.update();
        if (this.oAuth1.getUsed() && this.oAuth2.getUsed()) {
            throw (Throwable)new RuntimeException("You can not use OAuth 1.0 and OAuth 2 in the same request!");
        }
        if (this.oAuth1.getUsed()) {
            this.requestSpecification.auth().oauth(this.oAuth1.getConsumerKey(), this.oAuth1.getConsumerSecret(), this.oAuth1.getToken(), this.oAuth1.getTokenSecret());
        }
        if (this.oAuth2.getUsed()) {
            this.requestSpecification.auth().oauth2(this.oAuth2.getToken());
        }
        this.requestSpecification.baseUri("" + this.protocol + "://" + this.host);
        if (this.requestSpecification instanceof RequestSpecificationImpl) {
            this.setMethod((RequestSpecificationImpl)this.requestSpecification, method);
            this.setPath((RequestSpecificationImpl)this.requestSpecification, path2);
        }
        RequestSpecification requestSpecification = this.requestSpecification;
        if (requestSpecification == null) {
            throw new TypeCastException("null cannot be cast to non-null type io.restassured.internal.RequestSpecificationImpl");
        }
        RequestLogger requestLogger = new RequestLogger((RequestSpecificationImpl)requestSpecification);
        if (Settings.Companion.getLogAllEnabled()) {
            requestLogger.printIfNotPrinted();
        }
        try {
            ResponseOptions responseOptions = this.requestSpecification.request(method, path2, new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)responseOptions, (String)"requestSpecification.request(method, path)");
            response = (io.restassured.response.Response)responseOptions;
        }
        catch (Throwable e) {
            if (Settings.Companion.getLogIfFailedEnabled()) {
                requestLogger.printIfNotPrinted();
            }
            throw (Throwable)((Object)new AssertionError((Object)e));
        }
        return new ResponseImpl(requestLogger, response);
    }

    /*
     * WARNING - void declaration
     */
    private final void update() {
        Iterable $receiver$iv;
        block8: {
            block9: {
                void $receiver$iv$iv;
                $receiver$iv = this.setters;
                Iterable iterable = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    Setter setter = (Setter)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    String string = it.getClass().getSimpleName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.javaClass.simpleName");
                    CharSequence charSequence = string;
                    Regex regex = new Regex("$.+");
                    String string2 = "";
                    String string3 = regex.replace(charSequence, string2);
                    collection.add(string3);
                }
                List settersNames = (List)destination$iv$iv;
                if (!StringsKt.contains((CharSequence)this.contentType, (CharSequence)"json", (boolean)true) || !settersNames.contains("body") || !settersNames.contains("param")) break block8;
                Method method = this.method;
                if (method == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"method");
                }
                if (method == Method.POST) break block9;
                Method method2 = this.method;
                if (method2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"method");
                }
                if (method2 == Method.PUT) break block9;
                Method method3 = this.method;
                if (method3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"method");
                }
                if (method3 != Method.PATCH) break block8;
            }
            throw (Throwable)new RuntimeException("You can not use \"body\" setter and \"param\" setter at the same time, when content type is JSON");
        }
        $receiver$iv = this.setters;
        for (Object element$iv : $receiver$iv) {
            Setter it = (Setter)element$iv;
            it.update(this);
        }
    }

    private final void setMethod(@NotNull RequestSpecificationImpl $receiver, Method method) {
        $receiver.setMethod(method.toString());
    }

    private final void setPath(@NotNull RequestSpecificationImpl $receiver, String path2) {
        $receiver.path(path2);
    }

    public Request() {
        RequestSpecification requestSpecification = RestAssured.given().contentType(Settings.Companion.getContentType());
        if (requestSpecification == null) {
            Intrinsics.throwNpe();
        }
        this.requestSpecification = requestSpecification;
        this.oAuth1 = new OAuth1();
        this.oAuth2 = new OAuth2();
        this.contentType = Settings.Companion.getContentType();
        this.body = new HashMap();
        this.setters = new ArrayList();
        this.protocol = "http";
        this.host = "";
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/github/aivancioglo/resttest/http/Request$Companion;", "", "()V", "resttest-java"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

