/*
 * Decompiled with CFR 0.152.
 */
package com.github.aivancioglo.resttest.logger;

import com.github.aivancioglo.resttest.logger.ResponseLogger;
import io.restassured.http.Headers;
import io.restassured.internal.support.Prettifier;
import io.restassured.parsing.Parser;
import io.restassured.response.Response;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000f\u001a\u00020\u0006J\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0011R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/github/aivancioglo/resttest/logger/ResponseLogger;", "", "response", "Lio/restassured/response/Response;", "(Lio/restassured/response/Response;)V", "body", "", "<set-?>", "", "printed", "getPrinted", "()Z", "setPrinted", "(Z)V", "responseTime", "asString", "print", "", "printIfNotPrinted", "resttest-java"})
public final class ResponseLogger {
    private final String responseTime;
    private final String body;
    private boolean printed;
    private final Response response;

    public final boolean getPrinted() {
        return this.printed;
    }

    private final void setPrinted(boolean bl) {
        this.printed = bl;
    }

    @NotNull
    public final String asString() {
        StringBuilder stringBuilder = new StringBuilder().append("").append(this.response.getStatusLine()).append('\n').append("Duration: ").append(this.responseTime).append('\n');
        Headers headers2 = this.response.getHeaders();
        Intrinsics.checkExpressionValueIsNotNull((Object)headers2, (String)"response.headers");
        String responseLog2 = stringBuilder.append(CollectionsKt.joinToString$default((Iterable)((Iterable)headers2), (CharSequence)"\n", null, null, (int)0, null, (Function1)asString.responseLog.1.INSTANCE, (int)30, null)).toString();
        if (this.body != null) {
            CharSequence charSequence = this.body;
            String string = charSequence;
            if (string == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            charSequence = ((Object)StringsKt.trim((CharSequence)string)).toString();
            if (charSequence.length() > 0) {
                responseLog2 = responseLog2 + "\nBody:\n\n";
                responseLog2 = responseLog2 + this.body;
            }
        }
        responseLog2 = responseLog2 + "\n\n\n";
        return responseLog2;
    }

    public final void print() {
        String string = this.asString();
        System.out.print((Object)string);
        this.printed = true;
    }

    public final void printIfNotPrinted() {
        if (!this.printed) {
            this.print();
        }
    }

    public ResponseLogger(@NotNull Response response) {
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        this.response = response;
        this.responseTime = this.response.getTime() >= 0L ? "" + (double)this.response.getTime() / (double)1000 + " sec" : "" + this.response.getTime();
        this.body = this.response.getBody() != null ? new Prettifier().prettify(this.response.getBody().asString(), Parser.fromContentType((String)this.response.getContentType())) : null;
    }
}

