package com.eblly;

import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

import java.util.Date;

/**
 * joda 时间工具类
 * Created by eblly on 2017/6/2.
 */
public class DateKit {

    /**
     * 常用时间格式
     * yyyy
     * yyyy-MM
     * yyyy-MM-dd
     * yyyy-MM-dd HH
     * yyyy-MM-dd HH:mm
     * yyyy-MM-dd HH:mm:ss
     * MM-dd
     * dd
     * HH
     * HH:mm
     * HHmm
     * HH:mm:ss
     * yyyyMM
     * yyyyMMdd
     * yyyyMMddHHmmss
     * yyyyMMddHHmmssSSS
     **/
    private static final DateTimeFormatter yyyy = DateTimeFormat.forPattern("yyyy");
    private static final DateTimeFormatter ym = DateTimeFormat.forPattern("yyyy-MM");
    private static final DateTimeFormatter ymd = DateTimeFormat.forPattern("yyyy-MM-dd");
    private static final DateTimeFormatter ymdh = DateTimeFormat.forPattern("yyyy-MM-dd HH");
    private static final DateTimeFormatter ymdhm = DateTimeFormat.forPattern("yyyy-MM-dd HH:mm");
    private static final DateTimeFormatter ymdhms = DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss");
    private static final DateTimeFormatter md = DateTimeFormat.forPattern("MM-dd");
    private static final DateTimeFormatter dd = DateTimeFormat.forPattern("dd");
    private static final DateTimeFormatter hh = DateTimeFormat.forPattern("HH");
    private static final DateTimeFormatter hm = DateTimeFormat.forPattern("HH:mm");
    private static final DateTimeFormatter hm2 = DateTimeFormat.forPattern("HHmm");
    private static final DateTimeFormatter hms = DateTimeFormat.forPattern("HH:mm:ss");
    private static final DateTimeFormatter ym2 = DateTimeFormat.forPattern("yyyyMM");
    private static final DateTimeFormatter ymd2 = DateTimeFormat.forPattern("yyyyMMdd");
    private static final DateTimeFormatter ymdhms2 = DateTimeFormat.forPattern("yyyyMMddHHmmss");
    private static final DateTimeFormatter ymdhmss = DateTimeFormat.forPattern("yyyyMMddHHmmssSSS");


    /** 根据Date 返回相应格式的String **/

    /**
     * yyyy
     */
    public static String yFormat(Date date) {
        return new DateTime(date).toString("yyyy");
    }

    /**
     * yyyy-MM
     */
    public static String yMFormat(Date date) {
        return new DateTime(date).toString("yyyy-MM");
    }

    /**
     * yyyy-MM-dd
     */
    public static String yMdFormat(Date date) {
        return new DateTime(date).toString("yyyy-MM-dd");
    }

    /**
     * yyyy-MM-dd HH
     */
    public static String ymdhFormat(Date date) {
        return new DateTime(date).toString("yyyy-MM-dd HH");
    }

    /**
     * yyyy-MM-dd HH:mm
     */
    public static String ymdhmFormat(Date date) {
        return new DateTime(date).toString("yyyy-MM-dd HH:mm");
    }

    /**
     * yyyy-MM-dd HH:mm:ss
     */
    public static String ymdhmsFormat(Date date) {
        return new DateTime(date).toString("yyyy-MM-dd HH:mm:ss");
    }

    /**
     * MM-dd
     */
    public static String mdFormat(Date date) {
        return new DateTime(date).toString("MM-dd");
    }

    /**
     * dd
     */
    public static String dFormat(Date date) {
        return new DateTime(date).toString("dd");
    }

    /**
     * HH
     */
    public static String hFormat(Date date) {
        return new DateTime(date).toString("HH");
    }

    /**
     * HH:mm
     */
    public static String hmFormat(Date date) {
        return new DateTime(date).toString("HH:mm");
    }

    /**
     * HHmm
     */
    public static String hm2Format(Date date) {
        return new DateTime(date).toString("HHmm");
    }

    /**
     * HH:mm:ss
     */
    public static String hmsFormat(Date date) {
        return new DateTime(date).toString("HH:mm:ss");
    }

    /**
     * HHmmss
     */
    public static String hms2Format(Date date) {
        return new DateTime(date).toString("HHmmss");
    }

    /**
     * yyyyMM
     */
    public static String ymFormat(Date date) {
        return new DateTime(date).toString("yyyyMM");
    }

    /**
     * yyyyMMdd
     */
    public static String ymd2Format(Date date) {
        return new DateTime(date).toString("yyyyMMdd");
    }

    /**
     * yyyyMMddHHmmss
     */
    public static String ymdhms2Format(Date date) {
        return new DateTime(date).toString("yyyyMMddHHmmss");
    }

    /**
     * yyyyMMddHHmmssSSS
     */
    public static String ymdhmssFormat(Date date) {
        return new DateTime(date).toString("yyyyMMddHHmmssSSS");
    }

    /** 根据String返回相应格式的Date  **/

    /**
     * yyyy
     */
    public static Date yyyyParse(String dateStr) {
        return DateTime.parse(dateStr, yyyy).toDate();
    }

    /**
     * yyyy-MM
     */
    public static Date ymParse(String dateStr) {
        return DateTime.parse(dateStr, ym).toDate();
    }

    /**
     * yyyy-MM-dd
     */
    public static Date ymdParse(String dateStr) {
        return DateTime.parse(dateStr, ymd).toDate();
    }

    /**
     * yyyy-MM-dd HH
     */
    public static Date ymdhParse(String dateStr) {
        return DateTime.parse(dateStr, ymdh).toDate();
    }

    /**
     * yyyy-MM-dd HH:mm
     */
    public static Date ymdhmParse(String dateStr) {
        return DateTime.parse(dateStr, ymdhm).toDate();
    }

    /**
     * yyyy-MM-dd HH:mm:ss
     */
    public static Date ymdhmsParse(String dateStr) {
        return DateTime.parse(dateStr, ymdhms).toDate();
    }

    /**
     * MM-dd
     */
    public static Date mdParse(String dateStr) {
        return DateTime.parse(dateStr, md).toDate();
    }

    /**
     * dd
     */
    public static Date ddParse(String dateStr) {
        return DateTime.parse(dateStr, dd).toDate();
    }

    /**
     * HH
     */
    public static Date hhParse(String dateStr) {
        return DateTime.parse(dateStr, hh).toDate();
    }

    /**
     * HH:mm
     */
    public static Date hmParse(String dateStr) {
        return DateTime.parse(dateStr, hm).toDate();
    }

    /**
     * HHmm
     */
    public static Date hm2Parse(String dateStr) {
        return DateTime.parse(dateStr, hm2).toDate();
    }

    /**
     * HH:mm:ss
     */
    public static Date hmsParse(String dateStr) {
        return DateTime.parse(dateStr, hms).toDate();
    }

    /**
     * yyyyMM
     */
    public static Date ym2Parse(String dateStr) {
        return DateTime.parse(dateStr, ym2).toDate();
    }

    /**
     * yyyyMMdd
     */
    public static Date ymd2Parse(String dateStr) {
        return DateTime.parse(dateStr, ymd2).toDate();
    }

    /**
     * yyyyMMddHHmmss
     */
    public static Date ymdhms2Parse(String dateStr) {
        return DateTime.parse(dateStr, ymdhms2).toDate();
    }

    /**
     * yyyyMMddHHmmssSSS
     */
    public static Date ymdhmssParse(String dateStr) {
        return DateTime.parse(dateStr, ymdhmss).toDate();
    }


    /** 日期的计算 **/

    /**
     * 获取该日期的周几日期 , 周日为第一天
     *
     * @param date
     * @param dayOfWeek
     * @return
     */
    public static Date withDayOfWeek(Object date, int dayOfWeek) {
        DateTime dt = new DateTime(date);
        return dt.withDayOfWeek(dayOfWeek).toDate();
    }

    /**
     * 两个日期间相差的日期（精确至日）
     */
    public static int intervalDay(Date date1, Date date2) {
        DateTime dt1 = new DateTime(date1);
        DateTime dt2 = new DateTime(date2);

        int compare = dt1.compareTo(dt2);

        if (compare <= 0) {   //dt1 < dt2
            return Days.daysBetween(dt1.toLocalDate(), dt2.toLocalDate()).getDays();
        } else {
            return Days.daysBetween(dt2.toLocalDate(), dt1.toLocalDate()).getDays();
        }
    }

    /**
     * 两个日期间相差的天数（精确至秒）
     */
    public static int intervalDayTime(Date date1, Date date2) {
        DateTime dt1 = new DateTime(date1);
        DateTime dt2 = new DateTime(date2);

        int compare = dt1.compareTo(dt2);

        if (compare <= 0) {   //dt1 < dt2
            return Days.daysBetween(dt1.toLocalDateTime(), dt2.toLocalDateTime()).getDays();
        } else {
            return Days.daysBetween(dt2.toLocalDateTime(), dt1.toLocalDateTime()).getDays();
        }
    }

    /**
     * TODO 两个时间段相差的 分钟
     */


    /**
     * TODO
     * String date To String Date
     * 例如，时间字符串 2017-06-09 17:35:21 格式化成字符 17:35
     */

}
