package com.eblly;

import org.apache.http.HttpEntity;
import org.apache.http.client.methods.*;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.util.Map;

/**
 * TODO 待完善
 * Created by eblly on 2017/9/12.
 */
public class HttpUtils {
    private final static Logger log = LoggerFactory.getLogger(HttpUtils.class);


    /**
     * @param url
     * @param params
     * @return
     * @throws IOException
     */
    public String request(String url, Map<String, String> params, HttpMethod httpMethod) {
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse httpResponse = null;
        String content = null;

        try {
            httpClient = HttpClients.createDefault();
            //生成一个请求
            log.info("==>url:{}", url);

            HttpRequestBase httpRequestBase = null;
            switch (httpMethod) {
                case GET:
                    httpRequestBase = new HttpGet(url);
                    break;
                case POST:
                    httpRequestBase = new HttpPost(url);
                    break;
                case DELETE:
                    httpRequestBase = new HttpDelete(url);
                    break;
            }
            httpResponse = httpClient.execute(httpRequestBase);

            //解析返结果
            HttpEntity entity = httpResponse.getEntity();
            if (entity != null) {
                content = EntityUtils.toString(entity, "UTF-8");

                log.info("==>content: {}", content);
            }


        } catch (Exception e) {
            log.error("==>", e);
        } finally {
            try {
                httpClient.close();
            } catch (IOException e) {
                log.error("==>", e);
            }

            try {
                httpResponse.close();
            } catch (IOException e) {
                log.error("==>", e);
            }
        }

        return content;
    }
}


enum HttpMethod {
    POST("post"),
    GET("get"),
    DELETE("delete");

    private String name;

    HttpMethod(String name) {
        this.name = name;
    }

}