<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE mapper PUBLIC "-//mybatis.org//DTD Mapper 3.0//EN" "http://mybatis.org/dtd/mybatis-3-mapper.dtd">

<mapper namespace="${namespace}">
    <sql id="table">${table}</sql>

    <!-- insert -->
    <insert id="insert" parameterType="${parameterType}" keyProperty="id" useGeneratedKeys="true">
        insert into
        <include refid="table"/>
        ( <#list resultMap?keys as key>`${key}`<#if key_has_next>, </#if></#list> )
        values
        ( <#list resultMap?keys as key>${ "#{"  +  resultMap[key]  + "}" }<#if key_has_next>, </#if></#list> )
    </insert>

    <!-- update -->
    <update id="update" parameterType="${parameterType}">
        update
        <include refid="table"></include>
        <set>
            ( <#list resultMap?keys as key>`${key}`=${ "#{"  +  resultMap[key]  + "}" }<#if key_has_next>
            , </#if></#list> )
        </set>
        <where>
            id = ${ "#{" + "id}" }
        </where>
    </update>

    <!-- conditionSql -->
    <sql id="condition_sql">
    <#list resultMap?keys as key>
        <if test="${key} != null and ${key} != ''"> and `${key}` = ${ "#{" + resultMap[key] + "}" }</if>
    </#list>
    </sql>

    <!-- listPage -->
    <select id="listPage" parameterType="java.util.Map" resultMap="${selectResultMap}">
        select * from
        <include refid="table"/>
        <where>
            <include refid="condition_sql"/>
        </where>
    </select>

    <!-- listPageCount -->
    <select id="listPageCount" parameterType="java.util.Map" resultType="long">
        select count(1) from
        <include refid="table"/>
        <where>
            <include refid="condition_sql"/>
        </where>
    </select>

    <!-- listBuParams -->
    <select id="listByParams" parameterType="java.util.Map" resultMap="${selectResultMap}">
        select * from
        <include refid="table"/>
        <where>
            <include refid="condition_sql"/>
        </where>
    </select>

</mapper>