/*
 * Decompiled with CFR 0.152.
 */
package com.github.eventsource.client;

import com.github.eventsource.client.EventSourceClientHandler;
import com.github.eventsource.client.MessageDispatcher;
import com.github.eventsource.client.MessageEmitter;
import com.github.eventsource.client.MessageEvent;
import java.net.URI;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.http.DefaultHttpRequest;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.Timer;
import org.jboss.netty.util.TimerTask;

class EventSourceChannelHandler
extends SimpleChannelUpstreamHandler
implements MessageEmitter {
    private static final Pattern STATUS_PATTERN = Pattern.compile("HTTP/1.1 (\\d+) (.*)");
    private static final Pattern CONTENT_TYPE_PATTERN = Pattern.compile("Content-Type: text/event-stream");
    private final Executor executor;
    private final ClientBootstrap bootstrap;
    private final URI uri;
    private final EventSourceClientHandler eventSourceHandler;
    private final MessageDispatcher messageDispatcher;
    private final Timer timer = new HashedWheelTimer();
    private Channel channel;
    private boolean connecting = false;
    private boolean reconnectOnClose = true;
    private long reconnectionTimeMillis;
    private String lastEventId;
    private boolean eventStreamOk;
    private boolean headerDone;
    private Integer status;

    public EventSourceChannelHandler(Executor executor, long reconnectionTimeMillis, ClientBootstrap bootstrap, URI uri, EventSourceClientHandler eventSourceHandler) {
        this.executor = executor;
        this.reconnectionTimeMillis = reconnectionTimeMillis;
        this.bootstrap = bootstrap;
        this.uri = uri;
        this.eventSourceHandler = eventSourceHandler;
        this.messageDispatcher = new MessageDispatcher(this, uri.toString());
    }

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        super.handleUpstream(ctx, e);
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        DefaultHttpRequest request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, this.uri.toString());
        request.addHeader("Accept", (Object)"text/event-stream");
        request.addHeader("Host", (Object)this.uri.getHost());
        request.addHeader("Origin", (Object)("http://" + this.uri.getHost()));
        request.addHeader("Cache-Control", (Object)"no-cache");
        if (this.lastEventId != null) {
            request.addHeader("Last-Event-ID", (Object)this.lastEventId);
        }
        e.getChannel().write((Object)request);
        this.channel = e.getChannel();
        this.connecting = false;
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.emitDisconnect();
        this.channel = null;
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        if (!this.connecting && this.reconnectOnClose) {
            this.connecting = true;
            this.timer.newTimeout(new TimerTask(){

                public void run(Timeout timeout) throws Exception {
                    EventSourceChannelHandler.this.bootstrap.connect().await();
                }
            }, this.reconnectionTimeMillis, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void messageReceived(ChannelHandlerContext ctx, org.jboss.netty.channel.MessageEvent e) throws Exception {
        String line = (String)e.getMessage();
        if (this.status == null) {
            Matcher statusMatcher = STATUS_PATTERN.matcher(line);
            if (!statusMatcher.matches()) throw new RuntimeException("Not HTTP? " + line);
            this.status = Integer.parseInt(statusMatcher.group(1));
            if (this.status == 200) return;
            throw new RuntimeException("Bad status: " + this.status);
        }
        if (!this.headerDone) {
            if (CONTENT_TYPE_PATTERN.matcher(line).matches()) {
                this.eventStreamOk = true;
            }
            if (!line.isEmpty()) return;
            this.headerDone = true;
            if (!this.eventStreamOk) throw new RuntimeException("Not event stream");
            this.emitConnect();
            return;
        } else {
            this.messageDispatcher.line(line);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        Throwable error = e.getCause();
        this.emitError(error);
        ctx.getChannel().close();
    }

    @Override
    public void setReconnectionTime(long reconnectionTimeMillis) {
        this.reconnectionTimeMillis = reconnectionTimeMillis;
    }

    public EventSourceChannelHandler close() {
        this.reconnectOnClose = false;
        if (this.channel != null) {
            this.channel.close();
        }
        return this;
    }

    public EventSourceChannelHandler join() throws InterruptedException {
        if (this.channel != null) {
            this.channel.getCloseFuture().await();
        }
        return this;
    }

    private void emitConnect() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                EventSourceChannelHandler.this.eventSourceHandler.onConnect();
            }
        });
    }

    private void emitDisconnect() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                EventSourceChannelHandler.this.eventSourceHandler.onDisconnect();
            }
        });
    }

    private void emitError(final Throwable error) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                EventSourceChannelHandler.this.eventSourceHandler.onError(error);
            }
        });
    }

    @Override
    public void emitMessage(final String event, final MessageEvent message) {
        if (message.lastEventId != null) {
            this.lastEventId = message.lastEventId;
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                EventSourceChannelHandler.this.eventSourceHandler.onMessage(event, message);
            }
        });
    }
}

