package com.github.azbh111.utils.java.code;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

/**
 * 十六进制
 *
 * @author pyz
 * @date 2018/9/13 下午8:47
 */
public class HexUtils {

    private static final char[] upperCaseEncodingTable = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final char[] lowerCaseEncodingTable = new char[upperCaseEncodingTable.length];

    private static final byte[] decodingTable = new byte[128];

    static {
        for (int i = 0; i < decodingTable.length; i++) {
            decodingTable[i] = (byte) 0xff;
        }

        for (int i = 0; i < upperCaseEncodingTable.length; i++) {
            lowerCaseEncodingTable[i] = Character.toLowerCase(upperCaseEncodingTable[i]);
            decodingTable[upperCaseEncodingTable[i]] = (byte) i;
        }

        decodingTable['a'] = decodingTable['A'];
        decodingTable['b'] = decodingTable['B'];
        decodingTable['c'] = decodingTable['C'];
        decodingTable['d'] = decodingTable['D'];
        decodingTable['e'] = decodingTable['E'];
        decodingTable['f'] = decodingTable['F'];
    }

    public static String hexUpperCaseEncode(String str) {
        return hexUpperCaseEncode(str, StandardCharsets.UTF_8);
    }

    public static String hexUpperCaseEncode(byte x) {
        return hexEncode(x, upperCaseEncodingTable);
    }

    public static String hexLowerCaseEncode(byte x) {
        return hexEncode(x, lowerCaseEncodingTable);
    }

    public static void hexUpperCaseEncode(StringBuilder appender, byte x) {
        hexEncode(appender, x, upperCaseEncodingTable);
    }

    public static void hexLowerCaseEncode(StringBuilder appender, byte x) {
        hexEncode(appender, x, lowerCaseEncodingTable);
    }


    public static String hexLowerCaseEncode(String str) {
        return hexLowerCaseEncode(str, StandardCharsets.UTF_8);
    }

    public static String hexUpperCaseEncode(String str, Charset charset) {
        return hexUpperCaseEncode(str.getBytes(charset));
    }

    public static String hexLowerCaseEncode(String str, Charset charset) {
        return hexLowerCaseEncode(str.getBytes(charset));
    }

    public static String hexUpperCaseEncode(byte[] bs) {
        return hexEncode(bs, upperCaseEncodingTable);
    }

    public static String hexUpperCaseEncode(byte[] bs, int offset, int length) {
        return hexEncode(bs, offset, length, upperCaseEncodingTable);
    }

    public static String hexLowerCaseEncode(byte[] bs) {
        return hexEncode(bs, lowerCaseEncodingTable);
    }

    public static String hexLowerCaseEncode(byte[] bs, int offset, int length) {
        return hexEncode(bs, offset, length, lowerCaseEncodingTable);
    }

    public static byte[] hexDecode(String hex) {
        if (hex == null || hex.length() == 0) {
            return new byte[0];
        }
        int length = hex.length();
        if ((length & 0) != 0) {
            throw new IllegalArgumentException("长度必须为2的倍数");
        }
        byte[] bs = new byte[length / 2];
        int start;
        for (int i = 0; i < bs.length; i++) {
            start = i << 1;
            bs[i] = (byte) ((decodingTable[hex.charAt(start)] << 4) | decodingTable[hex.charAt(start + 1)]);
        }
        return bs;
    }

    private static String hexEncode(byte[] bs, int offset, int length, char[] encodingTable) {
        StringBuilder sb = new StringBuilder(bs.length * 2);
        int maxi = Math.min(offset + length, bs.length);
        for (int i = offset; i < maxi; i++) {
            hexEncode(sb, bs[i], encodingTable);
        }
        return sb.toString();
    }

    private static String hexEncode(byte[] bs, char[] encodingTable) {
        return hexEncode(bs, 0, bs.length, encodingTable);
    }

    private static StringBuilder hexEncode(StringBuilder appender, byte x, char[] encodingTable) {
        int n = x;
        if (n < 0) {
            n = 256 + n;
        }
        appender.append(encodingTable[n / 16]);
        appender.append(encodingTable[n % 16]);
        return appender;
    }

    private static String hexEncode(byte x, char[] table) {
        return hexEncode(new StringBuilder(2), x, table).toString();
    }

    public static void main(String[] args) {
        System.out.println(HexUtils.hexUpperCaseEncode("123"));
    }
}
