/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.io.jar;

import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.security.ProtectionDomain;

public class JarUtils {
    private static final String osName = System.getProperty("os.name").toLowerCase();

    public static Path getJar(Class clazz) throws Exception {
        String path;
        ProtectionDomain protectionDomain = clazz.getProtectionDomain();
        CodeSource codeSource = protectionDomain.getCodeSource();
        URI location = codeSource != null ? codeSource.getLocation().toURI() : null;
        String string = path = location != null ? location.getSchemeSpecificPart() : null;
        if (path == null) {
            throw new IllegalStateException("Unable to determine code source archive");
        }
        if (osName.contains("windows") && path.startsWith("/")) {
            path = path.substring(1);
        }
        return Paths.get(path, new String[0]);
    }
}

