/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.math.permutation;

import com.github.azbh111.utils.java.array.ArrayUtils;
import com.github.azbh111.utils.java.math.permutation.PermutationHolder;
import java.util.Comparator;

public class ObjectPermutationHolder<T>
extends PermutationHolder {
    private final Object[] arr;
    private final Comparator<Object> comparator;

    public <T extends Comparable> ObjectPermutationHolder(T[] arr) {
        this.arr = arr;
        this.comparator = new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return o1.compareTo(o2);
            }
        };
    }

    public <T> ObjectPermutationHolder(T[] arr, Comparator<T> comparator) {
        this.arr = arr;
        this.comparator = comparator;
    }

    @Override
    public int length() {
        return this.arr.length;
    }

    @Override
    public int compare(int i, int j) {
        return this.comparator.compare(this.arr[i], this.arr[j]);
    }

    @Override
    public void swap(int i, int j) {
        Object n = this.arr[i];
        this.arr[i] = this.arr[j];
        this.arr[j] = n;
    }

    @Override
    public void reverse(int fromIndex, int toIndex) {
        ArrayUtils.reverse(this.arr, fromIndex, toIndex);
    }
}

