/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.person;

import com.github.azbh111.utils.java.date.DateUtils;
import com.github.azbh111.utils.java.model.Res;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;

public class IdCardUtils {
    private static final Map<String, String> regionMap = new HashMap<String, String>();
    private static final char[] ValCodeArr = new char[]{'1', '0', 'X', '9', '8', '7', '6', '5', '4', '3', '2'};
    private static final int[] Wi = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};

    public static Res idCardValidate(String idChard) {
        if (idChard.length() != 15 && idChard.length() != 18) {
            return Res.fail("\u8eab\u4efd\u8bc1\u53f7\u7801\u957f\u5ea6\u5e94\u8be5\u4e3a18\u4f4d\u3002", new Object[0]);
        }
        int length = idChard.length();
        for (int i = 0; i < length; ++i) {
            if (Character.isDigit(idChard.charAt(i)) || i == length - 1 && idChard.charAt(i) == 'X') continue;
            return Res.fail("\u8eab\u4efd\u8bc1\u9664\u6700\u540e\u4e00\u4f4d\u53ef\u4ee5\u662fX\uff0c\u5176\u4f59\u90fd\u5e94\u662f\u6570\u5b57\u3002", new Object[0]);
        }
        String birthStr = idChard.substring(6, 14);
        LocalDate birth = null;
        try {
            birth = DateUtils.parse(birthStr, "yyyyMMdd");
        }
        catch (Throwable x) {
            return Res.fail("\u8eab\u4efd\u8bc1\u751f\u65e5\u65e0\u6548\u3002", new Object[0]);
        }
        if (birth.isAfter(LocalDate.now()) || birth.getYear() < 1900) {
            return Res.fail("\u8eab\u4efd\u8bc1\u751f\u65e5\u4e0d\u5728\u6709\u6548\u8303\u56f4\u3002", new Object[0]);
        }
        if (regionMap.containsKey(idChard.substring(0, 2))) {
            return Res.fail("\u8eab\u4efd\u8bc1\u5730\u533a\u7f16\u7801\u9519\u8bef\u3002", new Object[0]);
        }
        int verifyCodeInt = 0;
        for (int i = 0; i < 17; ++i) {
            verifyCodeInt += Integer.parseInt(String.valueOf(idChard.charAt(i))) * Wi[i];
        }
        int mod11 = verifyCodeInt % 11;
        char verifyCode = ValCodeArr[mod11];
        char lastCode = idChard.charAt(length - 1);
        if (verifyCode == 'X' && (lastCode == 'X' || lastCode == 'x')) {
            return Res.empty();
        }
        if (verifyCode != lastCode) {
            return Res.fail("\u8eab\u4efd\u8bc1\u6821\u9a8c\u7801\u9519\u8bef\u3002", new Object[0]);
        }
        return Res.empty();
    }

    static {
        regionMap.put("11", "\u5317\u4eac");
        regionMap.put("12", "\u5929\u6d25");
        regionMap.put("13", "\u6cb3\u5317");
        regionMap.put("14", "\u5c71\u897f");
        regionMap.put("15", "\u5185\u8499\u53e4");
        regionMap.put("21", "\u8fbd\u5b81");
        regionMap.put("22", "\u5409\u6797");
        regionMap.put("23", "\u9ed1\u9f99\u6c5f");
        regionMap.put("31", "\u4e0a\u6d77");
        regionMap.put("32", "\u6c5f\u82cf");
        regionMap.put("33", "\u6d59\u6c5f");
        regionMap.put("34", "\u5b89\u5fbd");
        regionMap.put("35", "\u798f\u5efa");
        regionMap.put("36", "\u6c5f\u897f");
        regionMap.put("37", "\u5c71\u4e1c");
        regionMap.put("41", "\u6cb3\u5357");
        regionMap.put("42", "\u6e56\u5317");
        regionMap.put("43", "\u6e56\u5357");
        regionMap.put("44", "\u5e7f\u4e1c");
        regionMap.put("45", "\u5e7f\u897f");
        regionMap.put("46", "\u6d77\u5357");
        regionMap.put("50", "\u91cd\u5e86");
        regionMap.put("51", "\u56db\u5ddd");
        regionMap.put("52", "\u8d35\u5dde");
        regionMap.put("53", "\u4e91\u5357");
        regionMap.put("54", "\u897f\u85cf");
        regionMap.put("61", "\u9655\u897f");
        regionMap.put("62", "\u7518\u8083");
        regionMap.put("63", "\u9752\u6d77");
        regionMap.put("64", "\u5b81\u590f");
        regionMap.put("65", "\u65b0\u7586");
        regionMap.put("71", "\u53f0\u6e7e");
        regionMap.put("81", "\u9999\u6e2f");
        regionMap.put("82", "\u6fb3\u95e8");
        regionMap.put("91", "\u56fd\u5916");
    }
}

