package com.github.azbh111.utils.java.lang;

import java.io.Serializable;
import java.util.Objects;

/**
 * @author: zyp
 * @date: 2020/6/20 8:10 上午
 */
public class Pair<L, R> implements Serializable, Comparable<Pair<L, R>> {

    private static final long serialVersionUID = 8144563253158271789L;
    private L left;
    private R right;

    public static <S, T> Pair<S, T> of(S left, T right) {
        return new Pair<>(left, right);
    }

    public static <L, R> int compare(Pair<L, R> left, Pair<L, R> right) {
        if (left == null) {
            if (right != null) {
                return -1;
            }
            return 0;
        } else if (right == null) {
            return 1;
        }
        return left.compareTo(right);
    }

    public Pair() {
    }

    public Pair(L left, R right) {
        this.left = left;
        this.right = right;
    }

    public L getLeft() {
        return left;
    }

    public R getRight() {
        return right;
    }

    public void setLeft(L left) {
        this.left = left;
    }

    public void setRight(R right) {
        this.right = right;
    }


    @Override
    public int compareTo(Pair<L, R> o) {
        if (this == o) {
            return 0;
        }
        L key1 = this.left;
        L key2 = o.left;
        if (key1 == null) {
            if (key2 != null) {
                return -1;
            }
//            两个key都是null
        } else if (key2 == null) {
            return 1;
        } else {
//            两个key都不是null
            int c = ((Comparable) key1).compareTo(key2);
            if (c != 0) {
                return c;
            }
        }

        R value1 = this.right;
        R value2 = o.right;
        if (value1 == null) {
            if (value2 != null) {
                return -1;
            }
//            两个value都是null
            return 0;
        } else if (value2 == null) {
            return 1;
        } else {
//            两个value都不是null
            return ((Comparable) value1).compareTo(value2);
        }
    }

    /**
     * 左右反转
     * 返回新的
     *
     * @return
     */
    public Pair<R, L> reverse() {
        return new Pair<>(right, left);
    }

    /**
     * 自身的left和right进行交换
     */
    public void reverseSelf() {
        Object tmp = left;
        left = (L) right;
        right = (R) tmp;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Pair<?, ?> pair = (Pair<?, ?>) o;
        return Objects.equals(left, pair.left) &&
                Objects.equals(right, pair.right);
    }

    @Override
    public int hashCode() {
        return Objects.hash(left, right);
    }

    @Override
    public String toString() {
        return "{" + left + ", " + right + '}';
    }
}
