package com.github.azbh111.utils.java.math.permutation;

import com.github.azbh111.utils.java.array.ArrayUtils;

/**
 *
 * @author pyz
 * @date 2019/4/14 11:13 AM
 */
public class FloatPermutationHolder extends PermutationHolder {
    private float[] arr;

    public FloatPermutationHolder(float[] arr) {
        this.arr = arr;
    }

    @Override
    public int length() {
        return arr.length;
    }

    @Override
    public int compare(int i, int j) {
        return Float.compare(arr[i], arr[j]);
    }

    @Override
    public void swap(int i, int j) {
        float n = arr[i];
        arr[i] = arr[j];
        arr[j] = n;
    }

    @Override
    public void reverse(int fromIndex, int toIndex) {
        ArrayUtils.reverse(arr, fromIndex, toIndex);
    }
}
