package com.github.azbh111.utils.java.properties;

import com.github.azbh111.utils.java.properties.annotation.Placeholder;
import com.github.azbh111.utils.java.resource.ResourceUtils;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Optional;
import java.util.Properties;

/**
 *
 * @author pyz
 * @date 2019/4/13 6:49 PM
 */
public class PlaceholderUtils {
    /**
     *
     * @param o
     * @param propertiesPath
     */
    public static void applyPropertiesConfig(Class clazz, Object o, String propertiesPath) throws IOException {
        InputStream is = ResourceUtils.getResourceAsStream(clazz, propertiesPath);
        if (is == null) {
            throw new NullPointerException("can not find " + propertiesPath + " in classpath.target=" + String.valueOf(o));
        }
        Properties properties = new Properties();
        properties.load(is);
        Class currentClass = o.getClass();
        while (currentClass != null && currentClass != Object.class) {
            for (Field field : currentClass.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers())) {
                    continue;
                }
                Placeholder placeholder = field.getAnnotation(Placeholder.class);
                if (placeholder == null) {
                    continue;
                }
                field.setAccessible(true);
                getValue(properties, placeholder, field.getType()).ifPresent(v -> {
                    try {
                        field.set(o, v);
                    } catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        }

    }

    /**
     *
     * @param clazz
     * @param propertiesPath
     */
    public static void applyStaticPropertiesConfig(Class location, Class clazz, String propertiesPath) throws IOException {
        InputStream is = ResourceUtils.getResourceAsStream(clazz, propertiesPath);
        if (is == null) {
            throw new NullPointerException("can not find " + propertiesPath + " in classpath.target=" + String.valueOf(clazz));
        }
        Properties properties = new Properties();
        properties.load(is);
        for (Field field : clazz.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers())) {
                continue;
            }
            Placeholder placeholder = field.getAnnotation(Placeholder.class);
            if (placeholder == null) {
                continue;
            }
            field.setAccessible(true);
            getValue(properties, placeholder, field.getType()).ifPresent(v -> {
                try {
                    field.set(null, v);
                } catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    private static <T> Optional<T> getValue(Properties properties, Placeholder config, Class<T> type) {
        String value = properties.getProperty(config.value());
        if (value == null && !config.defaultValue().isEmpty()) {
            value = config.defaultValue();
        }
        T t;
        if (value == null) {
            t = null;
        }
        if (type == Byte.class || type == Byte.TYPE) {
            t = (T) Byte.valueOf(value);
        } else if (type == Short.class || type == Short.TYPE) {
            t = (T) Short.valueOf(value);
        } else if (type == Integer.class || type == Integer.TYPE) {
            t = (T) Integer.valueOf(value);
        } else if (type == Long.class || type == Long.TYPE) {
            t = (T) Long.valueOf(value);
        } else if (type == Float.class || type == Float.TYPE) {
            t = (T) Float.valueOf(value);
        } else if (type == Double.class || type == Double.TYPE) {
            t = (T) Double.valueOf(value);
        } else if (type == Boolean.class || type == Boolean.TYPE) {
            t = (T) Boolean.valueOf(value);
        } else if (type == Character.class || type == Character.TYPE) {
            t = (T) (Character) value.charAt(0);
        } else {
            throw new UnsupportedOperationException("unsupported type:" + String.valueOf(type));
        }
        return Optional.ofNullable(t);
    }
}
