package com.github.azbh111.utils.java.reflect.model;

import java.lang.annotation.Annotation;
import java.util.function.Predicate;

/**
 * @author pyz
 * @date 2018/10/7 上午9:04
 */
class CommonFilter<T extends CommonFilter> {
    private String[] prefix;
    private String[] suffix;
    private String[] contains;
    private String[] name;
    private String[] notPrefix;
    private String[] notSuffix;
    private String[] notContains;
    private String[] notNames;
    private Class<? extends Annotation> annotationType;

    public Class<? extends Annotation> getAnnotationType() {
        return annotationType;
    }

    public T setAnnotationType(Class<? extends Annotation> annotationType) {
        this.annotationType = annotationType;
        return (T) this;
    }

    public String[] getNotPrefix() {
        return notPrefix;
    }

    public T setNotPrefix(String... notPrefix) {
        this.notPrefix = notPrefix;
        return (T) this;
    }

    public String[] getNotSuffix() {
        return notSuffix;
    }

    public T setNotSuffix(String... notSuffix) {
        this.notSuffix = notSuffix;
        return (T) this;
    }

    public String[] getNotContains() {
        return notContains;
    }

    public T setNotContains(String... notContains) {
        this.notContains = notContains;
        return (T) this;
    }

    public String[] getNotNames() {
        return notNames;
    }

    public T setNotNames(String... notNames) {
        this.notNames = notNames;
        return (T) this;
    }

    public String[] getPrefix() {
        return prefix;
    }

    public String[] getSuffix() {
        return suffix;
    }

    public String[] getContains() {
        return contains;
    }

    public String[] getName() {
        return name;
    }

    public T setPrefix(String... prefix) {
        this.prefix = prefix;
        return (T) this;
    }

    public T setSuffix(String... suffix) {
        this.suffix = suffix;
        return (T) this;
    }

    public T setContains(String... contains) {
        this.contains = contains;
        return (T) this;
    }

    public T setName(String... name) {
        this.name = name;
        return (T) this;
    }

    protected boolean filter(String name) {
        if (this.name != null) {
            if (match(this.name, s -> name.equals(s))) {
                return true;
            }
            return false;
        }
        if (notNames != null) {
            if (match(this.notNames, s -> name.equals(s))) {
                return false;
            }
        }
        if (notPrefix != null) {
            if (match(this.notPrefix, s -> name.startsWith(s))) {
                return false;
            }
        }
        if (notSuffix != null) {
            if (match(this.notSuffix, s -> name.endsWith(s))) {
                return false;
            }
        }
        if (notContains != null) {
            if (match(this.notContains, s -> name.contains(s))) {
                return false;
            }
        }
        if (!match(this.prefix, s -> name.startsWith(s))) {
            return false;
        }
        if (!match(this.suffix, s -> name.endsWith(s))) {
            return false;
        }
        if (!match(this.contains, s -> name.contains(s))) {
            return false;
        }
        return true;
    }

    protected <V> boolean match(V[] value, Predicate<V> predicate) {
        if (value == null) {
            return true;
        }
        for (V v : value) {
            if (predicate.test(v)) {
                return true;
            }
        }
        return false;
    }
}
