package com.github.azbh111.utils.java.reflect.model;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;

/**
 *
 * @author pyz
 * @date 2019/4/16 9:22 PM
 */
public class MuttableParameterizedType implements ParameterizedType {
    private Type rawType;
    private Type ownerType;
    private Type[] actualTypeArguments;

    public static MuttableParameterizedType[] of(ParameterizedType[] types) {
        if (types == null) {
            return new MuttableParameterizedType[0];
        }
        MuttableParameterizedType[] pts = new MuttableParameterizedType[types.length];
        for (int i = 0; i < types.length; i++) {
            pts[i] = of(types[i]);
        }
        return pts;
    }

    public static MuttableParameterizedType of(ParameterizedType type) {
        if (type == null) {
            return new MuttableParameterizedType();
        }
        MuttableParameterizedType pt = new MuttableParameterizedType();
        pt.rawType = type.getRawType();
        pt.ownerType = type.getOwnerType();
        pt.actualTypeArguments = type.getActualTypeArguments();
        return pt;
    }

    public MuttableParameterizedType() {
    }

    public void setRawType(Type rawType) {
        this.rawType = rawType;
    }

    public void setOwnerType(Type ownerType) {
        this.ownerType = ownerType;
    }

    public void setActualTypeArguments(Type[] actualTypeArguments) {
        this.actualTypeArguments = actualTypeArguments;
    }

    @Override
    public String toString() {
        StringBuilder var1 = new StringBuilder();
        if (this.ownerType != null) {
            if (this.ownerType instanceof Class) {
                var1.append(((Class) this.ownerType).getName());
            } else {
                var1.append(this.ownerType.toString());
            }

            var1.append(".");
            if (this.ownerType instanceof ParameterizedType) {
                var1.append(this.rawType.getTypeName().replace(((ParameterizedType) this.ownerType).getRawType().getTypeName() + "$", ""));
            } else {
                var1.append(this.rawType.getTypeName());
            }
        } else {
            var1.append(this.rawType.getTypeName());
        }

        if (this.actualTypeArguments != null && this.actualTypeArguments.length > 0) {
            var1.append("<");
            boolean var2 = true;
            Type[] var3 = this.actualTypeArguments;
            int var4 = var3.length;

            for (int var5 = 0; var5 < var4; ++var5) {
                Type var6 = var3[var5];
                if (!var2) {
                    var1.append(", ");
                }

                var1.append(var6.getTypeName());
                var2 = false;
            }

            var1.append(">");
        }

        return var1.toString();
    }

    @Override
    public Type[] getActualTypeArguments() {
        return actualTypeArguments;
    }

    @Override
    public Type getRawType() {
        return rawType;
    }

    @Override
    public Type getOwnerType() {
        return ownerType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        MuttableParameterizedType that = (MuttableParameterizedType) o;
        return Objects.equals(rawType, that.rawType) &&
                Objects.equals(ownerType, that.ownerType) &&
                Arrays.equals(actualTypeArguments, that.actualTypeArguments);
    }

    @Override
    public int hashCode() {

        int result = Objects.hash(rawType, ownerType);
        result = 31 * result + Arrays.hashCode(actualTypeArguments);
        return result;
    }
}