package com.github.azbh111.utils.java.reflect.model;

import java.lang.reflect.Field;

/**
 *
 * @author pyz
 * @date 2019/3/2 11:29 AM
 */
public class UnsafeField {
    private final long offset;
    private final Field field;
    private final Class type;

    private UnsafeField(Builder builder) {
        offset = builder.offset;
        field = builder.field;
        type = builder.type;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(UnsafeField copy) {
        Builder builder = new Builder();
        builder.offset = copy.getOffset();
        builder.field = copy.getField();
        builder.type = copy.getType();
        return builder;
    }

    public long getOffset() {
        return offset;
    }

    public Field getField() {
        return field;
    }

    public Class getType() {
        return type;
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("UnsafeField{");
        sb.append("offset=").append(offset);
        sb.append(", field=").append(field);
        sb.append(", type=").append(type);
        sb.append('}');
        return sb.toString();
    }

    /**
     * {@code UnsafeField} builder static inner class.
     */
    public static final class Builder {
        private long offset;
        private Field field;
        private Class type;

        private Builder() {
        }

        /**
         * Sets the {@code offset} and returns a reference to this Builder so that the methods can be chained together.
         * @param offset the {@code offset} to set
         * @return a reference to this Builder
         */
        public Builder offset(long offset) {
            this.offset = offset;
            return this;
        }

        /**
         * Sets the {@code field} and returns a reference to this Builder so that the methods can be chained together.
         * @param field the {@code field} to set
         * @return a reference to this Builder
         */
        public Builder field(Field field) {
            this.field = field;
            return this;
        }

        /**
         * Sets the {@code type} and returns a reference to this Builder so that the methods can be chained together.
         * @param type the {@code type} to set
         * @return a reference to this Builder
         */
        public Builder type(Class type) {
            this.type = type;
            return this;
        }

        /**
         * Returns a {@code UnsafeField} built from the parameters previously set.
         *
         * @return a {@code UnsafeField} built with parameters of this {@code UnsafeField.Builder}
         */
        public UnsafeField build() {
            return new UnsafeField(this);
        }
    }
}
