/*
 * Copyright (c) 2014-2019, Deepspring Healthcare Inc. All rights reserved.
 */

package com.github.azbh111.utils.java.web.model;

import lombok.ToString;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;

/**
 *
 */
@ToString
public class PageReq implements Serializable {
    private static final long serialVersionUID = -4891334089098635668L;
    private static int DEFAULT_PAGE_COUNT = 20;

    protected int page = 0;
    protected int count = DEFAULT_PAGE_COUNT;
    protected String keywords;
    protected Date startDate;
    protected Date endDate;
    /**
     * 简单的参数也可以放这里面,避免多写一个类
     */
    protected Map<String, String> extra;

    public static void setDefaultPageCount(int defaultPageCount) {
        DEFAULT_PAGE_COUNT = defaultPageCount;
    }

    public int getPage() {
        return page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getCount() {
        return count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public String getKeywords() {
        return keywords;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Map<String, String> getExtra() {
        return extra;
    }

    public void setExtra(Map<String, String> extra) {
        this.extra = extra;
    }
}