/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.javascript;

import com.github.azbh111.utils.java.resource.ResourceUtils;
import com.github.azbh111.utils.java.stack.StackTraceUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class JavaScriptUtils {
    public static Invocable loadScript(String path) throws IOException, ScriptException {
        URL in = ResourceUtils.getResource(StackTraceUtils.getCallerClass(), path);
        if (in == null) {
            return null;
        }
        try (InputStream is = in.openConnection().getInputStream();){
            Invocable invocable = JavaScriptUtils.resolveScript(new HashMap<String, Object>(), (ScriptEngine engine) -> engine.eval(new InputStreamReader(is, StandardCharsets.UTF_8)));
            return invocable;
        }
    }

    public static Invocable loadScript(String path, Map<String, Object> bindings) throws IOException, ScriptException {
        URL in = ResourceUtils.getResource(StackTraceUtils.getCallerClass(), path);
        if (in == null) {
            return null;
        }
        try (InputStream is = in.openConnection().getInputStream();){
            Invocable invocable = JavaScriptUtils.resolveScript(bindings, (ScriptEngine engine) -> engine.eval(new InputStreamReader(is, StandardCharsets.UTF_8)));
            return invocable;
        }
    }

    public static Invocable resolveScript(String script) throws IOException, ScriptException {
        return JavaScriptUtils.resolveScript(script, null);
    }

    public static Invocable resolveScript(String script, Map<String, Object> bindings) throws IOException, ScriptException {
        return JavaScriptUtils.resolveScript(bindings, (ScriptEngine engine) -> engine.eval(script));
    }

    private static Invocable resolveScript(Map<String, Object> bindings, ScriptEngineEval eval) throws IOException, ScriptException {
        ScriptEngineManager m = new ScriptEngineManager();
        ScriptEngine engine = m.getEngineByName("JavaScript");
        if (bindings != null && !bindings.isEmpty()) {
            bindings.forEach(engine::put);
        }
        eval.accept(engine);
        return (Invocable)((Object)engine);
    }

    static interface ScriptEngineEval {
        public void accept(ScriptEngine var1) throws ScriptException;
    }
}

