/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.sys;

import com.github.azbh111.utils.java.sys.OSUtils;
import com.github.azbh111.utils.java.thread.ThreadUtils;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.function.Consumer;

public class RuntimeUtils {
    public static void forceExit(long timeout, Consumer<String> logger, Consumer<Throwable> exceptionHandler) {
        if (logger == null) {
            logger = i -> {};
        }
        if (exceptionHandler == null) {
            exceptionHandler = Throwable::printStackTrace;
        }
        Consumer<Throwable> fExceptionHandler = exceptionHandler;
        Consumer<String> fLogger = logger;
        Thread t = new Thread(() -> {
            try {
                ThreadUtils.sleepSafe(timeout);
            }
            catch (Throwable e) {
                fExceptionHandler.accept(e);
            }
            try {
                RuntimeUtils.forceExit(fLogger);
            }
            catch (Throwable e) {
                fExceptionHandler.accept(e);
            }
        });
        t.setDaemon(true);
        t.setName("force exit watch dog");
        t.start();
        try {
            logger.accept("try System.exit(0)");
            System.exit(0);
        }
        catch (Exception e) {
            logger.accept("fail System.exit(0)");
            exceptionHandler.accept(e);
            RuntimeUtils.forceExit(logger);
        }
    }

    private static void forceExit(Consumer<String> logger) {
        String command;
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        String name = runtime.getName();
        logger.accept("process name: " + name);
        String pid = name.split("@")[0];
        logger.accept("process pid: " + pid);
        logger.accept("os name: " + OSUtils.getOSName());
        if (OSUtils.isWindows()) {
            command = "taskkill /pid " + pid + " /f";
        } else if (OSUtils.isMac() || OSUtils.isLinux()) {
            command = "kill -9 " + pid;
        } else {
            throw new RuntimeException("unkown os: " + OSUtils.getOSName());
        }
        logger.accept("command: " + command);
        ThreadUtils.sleepSafe(10L);
        try {
            Process process = Runtime.getRuntime().exec(command);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }
}

