package com.github.azbh111.utils.java.io.stream;

import java.io.IOException;
import java.io.InputStream;

/**
 * @author: zyp
 * @date: 2020/1/19 4:35 PM
 */
public class CounterInputStream extends InputStream {
    private final InputStream inputStream;
    private long count;

    public CounterInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    @Override
    public int read() throws IOException {
        int b = inputStream.read();
        if (b > 0) {
            count++;
        }
        return b;
    }

    public long getCount() {
        return count;
    }
}
