package com.github.azbh111.utils.java.string.model;

import java.text.CollationKey;

/**
 *
 * @author pyz
 * @date 2019/12/19 11:45 上午
 */
public class CollationKeyContainer<T> extends CollationKey {
    private final CollationKey delegate;
    private final T extend;

    public CollationKeyContainer(CollationKey delegate, T extend) {
        super(delegate.getSourceString());
        this.delegate = delegate;
        this.extend = extend;
    }

    @Override
    public int compareTo(CollationKey target) {
        // 必须传入原始的delegate,因为内部比较会强转为RuleBasedCollationKey
        return delegate.compareTo(((CollationKeyContainer) target).delegate);
    }

    @Override
    public byte[] toByteArray() {
        return delegate.toByteArray();
    }

    public T getExtend() {
        return extend;
    }
}