/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.image;

import com.github.azbh111.utils.java.image.val.ImageMetadata;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class ImageUtils {
    public boolean isImage(ImageInputStream input) {
        if (input == null) {
            return false;
        }
        return ImageIO.getImageReaders(input).hasNext();
    }

    public boolean isImage(InputStream input) throws IOException {
        if (input == null) {
            return false;
        }
        return this.isImage(ImageIO.createImageInputStream(input));
    }

    public boolean isImage(File input) throws IOException {
        if (input == null) {
            return false;
        }
        try (FileInputStream stream = new FileInputStream(input);){
            boolean bl = this.isImage(stream);
            return bl;
        }
    }

    public boolean isImage(URL input) throws IOException {
        if (input == null) {
            return false;
        }
        try (InputStream stream = input.openStream();){
            boolean bl = this.isImage(stream);
            return bl;
        }
    }

    public static ImageMetadata readImageMetadata(ImageInputStream iis) throws IOException {
        Iterator<ImageReader> readers = ImageIO.getImageReaders(iis);
        if (!readers.hasNext()) {
            return null;
        }
        ImageReader reader = readers.next();
        reader.setInput(iis, true);
        ImageMetadata meta = new ImageMetadata();
        meta.setWidth(reader.getWidth(0));
        meta.setHeight(reader.getHeight(0));
        meta.setFormat(reader.getFormatName());
        reader.getHeight(0);
        int channel = reader.getImageTypes(0).next().getSampleModel().getNumDataElements();
        meta.setChannel(channel);
        return meta;
    }

    public static ImageMetadata readImageMetadata(File file) throws IOException {
        try (FileInputStream stream = new FileInputStream(file);){
            ImageMetadata imageMetadata = ImageUtils.readImageMetadata(stream);
            return imageMetadata;
        }
    }

    public static ImageMetadata readImageMetadata(URL url) throws IOException {
        try (InputStream stream = url.openStream();){
            ImageMetadata imageMetadata = ImageUtils.readImageMetadata(stream);
            return imageMetadata;
        }
    }

    public static ImageMetadata readImageMetadata(InputStream stream) throws IOException {
        return ImageUtils.readImageMetadata(ImageIO.createImageInputStream(stream));
    }
}

