/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.lang;

import java.io.Serializable;
import java.util.Objects;

public class Triple<L, M, R>
implements Comparable<Triple<L, M, R>>,
Serializable {
    private static final long serialVersionUID = 1L;
    private L left;
    private M middle;
    private R right;

    public static <L, M, R> Triple<L, M, R> of(L left, M middle, R right) {
        return new Triple<L, M, R>(left, middle, right);
    }

    public static <L, M, R> int compare(Triple<L, M, R> left, Triple<L, M, R> right) {
        if (left == null) {
            if (right != null) {
                return -1;
            }
            return 0;
        }
        if (right == null) {
            return 1;
        }
        return left.compareTo(right);
    }

    public Triple() {
    }

    public Triple(L left, M middle, R right) {
        this.left = left;
        this.middle = middle;
        this.right = right;
    }

    public Triple<R, M, L> reverse() {
        return new Triple<R, M, L>(this.right, this.middle, this.left);
    }

    public void reverseSelf() {
        L tmp = this.left;
        this.left = this.right;
        this.right = tmp;
    }

    public L getLeft() {
        return this.left;
    }

    public void setLeft(L left) {
        this.left = left;
    }

    public M getMiddle() {
        return this.middle;
    }

    public void setMiddle(M middle) {
        this.middle = middle;
    }

    public R getRight() {
        return this.right;
    }

    public void setRight(R right) {
        this.right = right;
    }

    @Override
    public int compareTo(Triple<L, M, R> o) {
        if (this == o) {
            return 0;
        }
        L left1 = this.left;
        L left2 = o.left;
        if (left1 == null) {
            if (left2 != null) {
                return -1;
            }
        } else {
            if (left2 == null) {
                return 1;
            }
            int c = ((Comparable)left1).compareTo(left2);
            if (c != 0) {
                return c;
            }
        }
        M middle1 = this.middle;
        M middle2 = o.middle;
        if (middle1 == null) {
            if (middle2 != null) {
                return -1;
            }
        } else {
            if (middle2 == null) {
                return 1;
            }
            int c = ((Comparable)middle1).compareTo(middle2);
            if (c != 0) {
                return c;
            }
        }
        R right1 = this.right;
        R right2 = o.right;
        if (right1 == null) {
            if (right2 != null) {
                return -1;
            }
            return 0;
        }
        if (right2 == null) {
            return 1;
        }
        return ((Comparable)right1).compareTo(right2);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Triple triple = (Triple)o;
        return Objects.equals(this.left, triple.left) && Objects.equals(this.middle, triple.middle) && Objects.equals(this.right, triple.right);
    }

    public int hashCode() {
        return Objects.hash(this.left, this.middle, this.right);
    }

    public String toString() {
        return "{" + this.left + ", " + this.middle + ", " + this.right + '}';
    }
}

