/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.promise;

import com.github.azbh111.utils.java.promise.PromiseCatch;
import com.github.azbh111.utils.java.promise.PromiseFinally;
import com.github.azbh111.utils.java.promise.PromiseStatus;
import com.github.azbh111.utils.java.promise.PromiseThen;
import java.util.concurrent.atomic.AtomicInteger;

public class Promise {
    private PromiseStatus status = PromiseStatus.PENDING;
    private Object resolvedObject;
    private Object rejectedObject;
    private Object nextResolvedObject;
    private Object nextRejectedObject;
    private PromiseThen thennable;
    private PromiseCatch catchable;
    private PromiseFinally finnable;
    private Promise next;

    public synchronized void resolve(Object resolvedObject) {
        if (this.status != PromiseStatus.PENDING) {
            return;
        }
        this.status = PromiseStatus.RESOLVED;
        this.resolvedObject = resolvedObject;
        this.run();
    }

    public synchronized void reject(Object rejectedObject) {
        if (this.status != PromiseStatus.PENDING) {
            return;
        }
        this.status = PromiseStatus.REJECTED;
        this.rejectedObject = rejectedObject;
        this.run();
    }

    public void await() throws InterruptedException {
        this.await(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void await(long timeout) throws InterruptedException {
        boolean keepWaiting = timeout == 0L;
        long leftWaitTimeNano = timeout * 1000000L;
        while (this.status == PromiseStatus.PENDING) {
            if (!keepWaiting && leftWaitTimeNano <= 0L) {
                return;
            }
            Promise promise = this;
            synchronized (promise) {
                if (this.status != PromiseStatus.PENDING) {
                    return;
                }
                long start = System.nanoTime();
                this.wait(leftWaitTimeNano / 1000000L, (int)(leftWaitTimeNano % 1000000L));
                long end = System.nanoTime();
                if (keepWaiting) {
                    continue;
                }
                leftWaitTimeNano -= end - start;
            }
        }
        return;
    }

    private synchronized Promise then(PromiseThen thennable, PromiseCatch catchable, PromiseFinally finnable) {
        this.thennable = thennable;
        this.catchable = catchable;
        this.finnable = finnable;
        this.next = new Promise();
        this.run();
        return this.next;
    }

    private void handleNextResolve(Object resolvedObject, Promise promise) {
        if (resolvedObject instanceof Promise) {
            Promise p = (Promise)resolvedObject;
            p.then(o -> {
                promise.resolve(o);
                return null;
            }).catch_(e -> {
                promise.reject(e);
                return null;
            });
        } else {
            promise.resolve(resolvedObject);
        }
    }

    private void run() {
        if (this.status == PromiseStatus.PENDING) {
            return;
        }
        this.nextRejectedObject = null;
        this.nextResolvedObject = null;
        try {
            if (this.status == PromiseStatus.RESOLVED) {
                this.nextResolvedObject = this.thennable != null ? this.thennable.apply(this.resolvedObject) : this.resolvedObject;
            }
            if (this.status == PromiseStatus.REJECTED) {
                if (this.catchable != null) {
                    this.nextResolvedObject = this.catchable.apply(this.rejectedObject);
                } else {
                    this.nextRejectedObject = this.rejectedObject;
                }
            }
            if (this.finnable != null) {
                this.finnable.run();
            }
            this.notifyAll();
        }
        catch (Throwable e) {
            this.nextRejectedObject = e;
            this.notifyAll();
            if (this.next != null) {
                this.next.reject(this.nextRejectedObject);
            }
            return;
        }
        if (this.next != null) {
            if (this.status == PromiseStatus.REJECTED && this.catchable == null) {
                this.next.reject(this.nextRejectedObject);
            } else {
                this.handleNextResolve(this.nextResolvedObject, this.next);
            }
        }
    }

    public Promise then(PromiseThen thennable) {
        return this.then(thennable, null, null);
    }

    public Promise catch_(PromiseCatch catchable) {
        return this.then(null, catchable, null);
    }

    public Promise finally_(PromiseFinally finnable) {
        return this.then(null, null, finnable);
    }

    public <T> T getResolvedObject() {
        return (T)this.resolvedObject;
    }

    public <T> T getRejectedObject() {
        return (T)this.rejectedObject;
    }

    public PromiseStatus getStatus() {
        return this.status;
    }

    public boolean isPending() {
        return this.status == PromiseStatus.PENDING;
    }

    public boolean isResolved() {
        return this.status == PromiseStatus.RESOLVED;
    }

    public boolean isRejected() {
        return this.status == PromiseStatus.REJECTED;
    }

    public static Promise all(Promise ... others) {
        Promise promise = new Promise();
        int size = others.length;
        Object[] results = new Object[size];
        AtomicInteger count = new AtomicInteger();
        for (int i = 0; i < size; ++i) {
            int j = i;
            others[i].then(res -> {
                results[j] = res;
                if (count.incrementAndGet() == size) {
                    promise.resolve(results);
                }
                return null;
            }).catch_(e -> {
                promise.reject(e);
                return null;
            });
        }
        return promise;
    }
}

