package com.github.azbh111.utils.java.csv;

import lombok.*;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Function;

/**
 * @author: zyp
 * @date: 2020/12/4 17:54
 */
@Getter
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
@ToString(callSuper = true)
class CsvColumnDefine {
    private String name;
    private int order;
    private Field field;
    private Method method;
    private Function<Object, String> conventor;
    private String nullValue;

    public Object get(Object item) throws InvocationTargetException, IllegalAccessException {
        if (method != null) {
            return method.invoke(item);
        }
        return field.get(item);
    }
}
